/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.stability.Unstable;

@Unstable
public class PageClassPropertyReference
extends EntityReference {
    public PageClassPropertyReference(EntityReference reference) {
        super(reference);
    }

    protected PageClassPropertyReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public PageClassPropertyReference(String propertyName, PageReference classReference) {
        super(propertyName, EntityType.PAGE_CLASS_PROPERTY, (EntityReference)classReference);
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE_CLASS_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a class property reference");
        }
        super.setType(type);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof PageReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a class property reference");
        }
        super.setParent(new PageReference(parent));
    }

    @Override
    public PageClassPropertyReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new PageClassPropertyReference(this, oldParent, newParent);
    }
}

