/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.stability.Unstable;

@Unstable
public class PageObjectReference
extends EntityReference {
    public PageObjectReference(EntityReference reference) {
        super(reference);
    }

    protected PageObjectReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public PageObjectReference(String objectName, PageReference pageReference) {
        super(objectName, EntityType.PAGE_OBJECT, (EntityReference)pageReference);
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE_OBJECT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an object reference");
        }
        super.setType(type);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof PageReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in an object reference");
        }
        super.setParent(new PageReference(parent));
    }

    @Override
    public PageObjectReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new PageObjectReference(this, oldParent, newParent);
    }

    @Transient
    public PageReference getPageReference() {
        return (PageReference)this.getParent();
    }
}

