/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference.converter;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.EnumUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class EntityReferenceConverter
extends AbstractConverter<EntityReference> {
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> stringResolver;
    @Inject
    private EntityReferenceSerializer<String> serialier;

    protected EntityReference convertToType(Type type, Object value) {
        if (value == null) {
            return null;
        }
        return this.convertToType(type, value.toString());
    }

    private EntityReference convertToType(Type type, String value) {
        Namespace namespace = NamespaceUtils.toNamespace((String)value);
        EntityType entityType = namespace.getType() != null ? (EntityType)EnumUtils.getEnum(EntityType.class, (String)namespace.getType().toUpperCase()) : null;
        String entityReference = namespace.getValue();
        if (entityType == null) {
            entityType = EntityType.DOCUMENT;
            entityReference = value;
        }
        return this.stringResolver.resolve(entityReference, entityType, new Object[0]);
    }

    protected String convertToString(EntityReference value) {
        if (value == null) {
            return null;
        }
        return new Namespace(value.getType().getLowerCase(), this.serialier.serialize(value, new Object[0])).toString();
    }
}

