/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.stability.Unstable;

@Unstable
public class PageAttachmentReference
extends EntityReference {
    public PageAttachmentReference(EntityReference reference) {
        super(reference);
    }

    protected PageAttachmentReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public PageAttachmentReference(String fileName, PageReference parent) {
        super(fileName, EntityType.PAGE_ATTACHMENT, (EntityReference)parent);
    }

    public PageAttachmentReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof PageReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in an attachment reference");
        }
        super.setParent(new PageReference(parent));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE_ATTACHMENT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an attachment reference");
        }
        super.setType(type);
    }

    @Transient
    public PageReference getPageReference() {
        return (PageReference)this.extractReference(EntityType.PAGE);
    }

    @Override
    public PageAttachmentReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new PageAttachmentReference(this, oldParent, newParent);
    }

    @Override
    public PageAttachmentReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new PageAttachmentReference((EntityReference)this, newParent);
    }
}

