/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ClassPropertyReference
extends EntityReference {
    public ClassPropertyReference(EntityReference reference) {
        super(reference);
    }

    protected ClassPropertyReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public ClassPropertyReference(String propertyName, DocumentReference classReference) {
        super(propertyName, EntityType.CLASS_PROPERTY, (EntityReference)classReference);
    }

    public ClassPropertyReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    @Deprecated
    public ClassPropertyReference(String wiki, String space, String page, String propertyName) {
        this(propertyName, new DocumentReference(wiki, space, page));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.CLASS_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a class property reference");
        }
        super.setType(EntityType.CLASS_PROPERTY);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof DocumentReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a class property reference");
        }
        super.setParent(new DocumentReference(parent));
    }

    @Override
    public ClassPropertyReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new ClassPropertyReference(this, oldParent, newParent);
    }

    @Override
    public ClassPropertyReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new ClassPropertyReference((EntityReference)this, newParent);
    }
}

