/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.scripting;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="model")
@Singleton
public class ModelScriptService
implements ScriptService {
    private static final String DEFAULT_STRING_RESOLVER_HINT = "currentmixed";
    @Inject
    private ComponentManager componentManager;

    public DocumentReference createDocumentReference(String wiki, String space, String page) {
        return this.createDocumentReference(wiki, space, page, "currentmixed/reference");
    }

    public DocumentReference createDocumentReference(String wiki, String space, String page, String hint) {
        DocumentReference documentReference;
        EntityReference reference = null;
        if (!StringUtils.isEmpty((CharSequence)wiki)) {
            reference = new EntityReference(wiki, EntityType.WIKI);
        }
        if (!StringUtils.isEmpty((CharSequence)space)) {
            reference = new EntityReference(space, EntityType.SPACE, reference);
        }
        if (!StringUtils.isEmpty((CharSequence)page)) {
            reference = new EntityReference(page, EntityType.DOCUMENT, reference);
        }
        try {
            documentReference = ((DocumentReferenceResolver)this.componentManager.lookup(DocumentReferenceResolver.class, hint)).resolve(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            documentReference = null;
        }
        return documentReference;
    }

    public AttachmentReference createAttachmentReference(DocumentReference documentReference, String fileName) {
        return new AttachmentReference(fileName, documentReference);
    }

    public DocumentReference resolveDocument(String stringRepresentation) {
        return this.resolveDocument(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public DocumentReference resolveDocument(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new DocumentReference(resolver.resolve(stringRepresentation, EntityType.DOCUMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public AttachmentReference resolveAttachment(String stringRepresentation) {
        return this.resolveAttachment(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public AttachmentReference resolveAttachment(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new AttachmentReference(resolver.resolve(stringRepresentation, EntityType.ATTACHMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public ObjectReference resolveObject(String stringRepresentation) {
        return this.resolveObject(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public ObjectReference resolveObject(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new ObjectReference(resolver.resolve(stringRepresentation, EntityType.OBJECT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public ObjectPropertyReference resolveObjectProperty(String stringRepresentation) {
        return this.resolveObjectProperty(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public ObjectPropertyReference resolveObjectProperty(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new ObjectPropertyReference(resolver.resolve(stringRepresentation, EntityType.OBJECT_PROPERTY, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public String serialize(EntityReference reference) {
        return this.serialize(reference, "compact");
    }

    public String serialize(EntityReference reference, String hint) {
        String result;
        try {
            result = (String)((EntityReferenceSerializer)this.componentManager.lookup(EntityReferenceSerializer.class, hint)).serialize(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            result = null;
        }
        return result;
    }
}

