/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ClassPropertyReference
extends EntityReference {
    public ClassPropertyReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public ClassPropertyReference(String propertyName, DocumentReference classReference) {
        super(propertyName, EntityType.CLASS_PROPERTY, classReference);
    }

    public ClassPropertyReference(String wiki, String space, String page, String propertyName) {
        this(propertyName, new DocumentReference(wiki, space, page));
    }

    @Override
    public void setType(EntityType type) {
        if (type != EntityType.CLASS_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an class property reference");
        }
        super.setType(EntityType.CLASS_PROPERTY);
    }

    @Override
    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for an class property " + "reference");
        }
        super.setParent(new DocumentReference(parent));
    }
}

