/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
public class DefaultStringEntityReferenceSerializer
implements EntityReferenceSerializer<String> {
    private static final Map<EntityType, String[]> ESCAPES = new HashMap<EntityType, String[]>(){
        {
            this.put(EntityType.ATTACHMENT, new String[]{"@", "\\"});
            this.put(EntityType.DOCUMENT, new String[]{".", "\\"});
            this.put(EntityType.SPACE, new String[]{":", ".", "\\"});
            this.put(EntityType.OBJECT, new String[]{"^", "\\"});
            this.put(EntityType.OBJECT_PROPERTY, new String[]{".", "\\"});
            this.put(EntityType.CLASS_PROPERTY, new String[]{"^", ".", "\\"});
        }
    };
    private static final Map<EntityType, String[]> REPLACEMENTS = new HashMap<EntityType, String[]>(){
        {
            this.put(EntityType.ATTACHMENT, new String[]{"\\@", "\\\\"});
            this.put(EntityType.DOCUMENT, new String[]{"\\.", "\\\\"});
            this.put(EntityType.SPACE, new String[]{"\\:", "\\.", "\\\\"});
            this.put(EntityType.OBJECT, new String[]{"\\^", "\\\\"});
            this.put(EntityType.OBJECT_PROPERTY, new String[]{"\\.", "\\\\"});
            this.put(EntityType.CLASS_PROPERTY, new String[]{"\\^", "\\.", "\\\\"});
        }
    };

    @Override
    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder representation = new StringBuilder();
        for (EntityReference currentReference = reference.getRoot(); currentReference != null && currentReference != reference.getChild(); currentReference = currentReference.getChild()) {
            this.serializeEntityReference(currentReference, representation, currentReference == reference, parameters);
        }
        return representation.toString();
    }

    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        String[] currentEscapeChars = ESCAPES.get((Object)currentReference.getType());
        if (currentEscapeChars != null) {
            representation.append(StringUtils.replaceEach((String)currentReference.getName(), (String[])currentEscapeChars, (String[])REPLACEMENTS.get((Object)currentReference.getType())));
        } else {
            representation.append(currentReference.getName().replace("\\", "\\\\"));
        }
        if (!isLastReference && currentReference.getChild() != null) {
            String separatorChar = ESCAPES.get((Object)currentReference.getChild().getType())[0];
            representation.append(separatorChar);
        }
    }
}

