/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

public class DocumentReference
extends EntityReference {
    private static final String LOCALE = "LOCALE";

    public DocumentReference(EntityReference reference) {
        super(reference);
    }

    protected DocumentReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public DocumentReference(EntityReference reference, Locale locale) {
        super(reference);
        this.setLocale(locale);
    }

    public DocumentReference(String wikiName, String spaceName, String pageName) {
        this(pageName, new SpaceReference(spaceName, new WikiReference(wikiName)));
    }

    public DocumentReference(String wikiName, String spaceName, String pageName, Locale locale) {
        this(pageName, new SpaceReference(spaceName, new WikiReference(wikiName)), locale);
    }

    public DocumentReference(String wikiName, String spaceName, String pageName, String language) {
        this(pageName, new SpaceReference(spaceName, new WikiReference(wikiName)), language == null ? null : new Locale(language));
    }

    public DocumentReference(String wikiName, List<String> spaceNames, String pageName) {
        super(pageName, EntityType.DOCUMENT, DocumentReference.constructSpaceReference(wikiName, spaceNames));
    }

    public DocumentReference(String wikiName, List<String> spaceNames, String pageName, Locale locale) {
        super(pageName, EntityType.DOCUMENT, DocumentReference.constructSpaceReference(wikiName, spaceNames));
        this.setLocale(locale);
    }

    public DocumentReference(String pageName, SpaceReference parent) {
        super(pageName, EntityType.DOCUMENT, (EntityReference)parent);
    }

    public DocumentReference(LocalDocumentReference localDocumentReference, WikiReference wikiReference) {
        super(localDocumentReference, null, (EntityReference)wikiReference);
    }

    public DocumentReference(String pageName, SpaceReference parent, Locale locale) {
        super(pageName, EntityType.DOCUMENT, (EntityReference)parent);
        this.setLocale(locale);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof SpaceReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.SPACE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a document reference");
        }
        super.setParent(new SpaceReference(parent));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a document reference");
        }
        super.setType(EntityType.DOCUMENT);
    }

    protected void setLocale(Locale locale) {
        this.setParameter(LOCALE, locale);
    }

    public Locale getLocale() {
        return (Locale)this.getParameter(LOCALE);
    }

    public WikiReference getWikiReference() {
        return (WikiReference)this.extractReference(EntityType.WIKI);
    }

    public SpaceReference getLastSpaceReference() {
        return (SpaceReference)this.extractReference(EntityType.SPACE);
    }

    public List<SpaceReference> getSpaceReferences() {
        ArrayList<SpaceReference> references = new ArrayList<SpaceReference>();
        for (EntityReference reference = this; reference != null; reference = reference.getParent()) {
            if (reference.getType() != EntityType.SPACE) continue;
            references.add((SpaceReference)reference);
        }
        Collections.reverse(references);
        return references;
    }

    private static EntityReference constructSpaceReference(String wikiName, List<String> spaceNames) {
        EntityReference spaceReference = null;
        EntityReference parent = new EntityReference(wikiName, EntityType.WIKI);
        for (String spaceName : spaceNames) {
            parent = spaceReference = new EntityReference(spaceName, EntityType.SPACE, parent);
        }
        return spaceReference;
    }

    @Override
    public DocumentReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new DocumentReference(this, oldParent, newParent);
    }

    @Override
    public String toString() {
        return TOSTRING_SERIALIZER.serialize(this, new Object[0]);
    }
}

