/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class EntityReferenceSet {
    private EntityReferenceEntry includes;
    private EntityReferenceEntry excludes;

    private void add(EntityReference reference, EntityReferenceEntry entry) {
        EntityReferenceEntry currentEntry = entry;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            while (currentEntry.childrenType != null && currentEntry.childrenType.compareTo(element.getType()) < 0) {
                currentEntry = currentEntry.add();
            }
            if (currentEntry.childrenType == null || currentEntry.childrenType == element.getType()) {
                currentEntry.childrenType = element.getType();
                currentEntry = currentEntry.add(element.getType(), element.getName(), element.getParameters());
                continue;
            }
            EntityReferenceEntry newEntry = new EntityReferenceEntry(currentEntry);
            currentEntry.reset();
            currentEntry.add(newEntry);
        }
    }

    public EntityReferenceSet includes(EntityReference reference) {
        if (this.includes == null) {
            this.includes = new EntityReferenceEntry();
        }
        this.add(reference, this.includes);
        return this;
    }

    public EntityReferenceSet excludes(EntityReference reference) {
        if (this.excludes == null) {
            this.excludes = new EntityReferenceEntry();
        }
        this.add(reference, this.excludes);
        return this;
    }

    private boolean matchesInclude(EntityReference reference) {
        if (this.includes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.includes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return true;
            }
            if (currentEntry.childrenType != element.getType()) continue;
            EntityReferenceEntry nameEntry = currentEntry.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = currentEntry.children.get(null);
                if (currentEntry == null) {
                    return false;
                }
            } else {
                currentEntry = nameEntry;
            }
            if (currentEntry.matches(element)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesExclude(EntityReference reference) {
        if (this.excludes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.excludes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return false;
            }
            if (currentEntry.childrenType != element.getType()) continue;
            EntityReferenceEntry nameEntry = currentEntry.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = currentEntry.children.get(null);
                if (currentEntry == null) {
                    return true;
                }
            } else {
                currentEntry = nameEntry;
            }
            if (currentEntry.matches(element)) continue;
            return true;
        }
        return currentEntry.children != null || currentEntry.parameters != null && CollectionUtils.intersection(this.getParametersKeys(currentEntry.parameters), reference.getParameters().keySet()).isEmpty();
    }

    private Set<String> getParametersKeys(List<Map<String, Serializable>> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map<String, Serializable> map : parameters) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public boolean matches(EntityReference reference) {
        return this.matchesInclude(reference) && this.matchesExclude(reference);
    }

    private static class EntityReferenceEntry {
        public EntityType type;
        public String name;
        public List<Map<String, Serializable>> parameters;
        public EntityType childrenType;
        public Map<String, EntityReferenceEntry> children;

        public EntityReferenceEntry() {
        }

        public EntityReferenceEntry(EntityType type, String name) {
            this.type = type;
            this.name = name;
        }

        public EntityReferenceEntry(EntityReferenceEntry entry) {
            this(entry.type, entry.name);
            this.childrenType = entry.childrenType;
            this.children = entry.children;
            this.parameters = entry.parameters;
        }

        public EntityReferenceEntry add() {
            return this.add(null, null, null);
        }

        public void add(EntityReferenceEntry entry) {
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            this.children.put(entry.name, entry);
        }

        public EntityReferenceEntry add(EntityType entityType, String name, Map<String, Serializable> entityParameters) {
            EntityReferenceEntry entry;
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            if ((entry = this.children.get(name)) == null) {
                entry = new EntityReferenceEntry(entityType, name);
                if (entityParameters != null) {
                    entry.addParameters(entityParameters);
                }
                this.children.put(name, entry);
            } else if (!entry.matches(entityParameters)) {
                entry.addParameters(entityParameters);
            }
            return entry;
        }

        private void addParameters(Map<String, Serializable> entityParameters) {
            if (!entityParameters.isEmpty()) {
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Map<String, Serializable>>();
                }
                this.parameters.add(entityParameters);
            }
        }

        public void reset() {
            this.childrenType = null;
            this.children = null;
        }

        public boolean matches(EntityReference reference) {
            return this.matches(reference.getParameters());
        }

        public boolean matches(Map<String, Serializable> referenceParameters) {
            if (this.parameters == null) {
                return true;
            }
            boolean matches = this.parameters.isEmpty();
            for (Map<String, Serializable> parametersMap : this.parameters) {
                matches |= this.matches(referenceParameters, parametersMap);
            }
            return matches;
        }

        private boolean matches(Map<String, Serializable> referenceParameters, Map<String, Serializable> map) {
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                if (!referenceParameters.containsKey(entry.getKey()) || Objects.equals(entry.getValue(), referenceParameters.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
    }
}

