/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.InvalidEntityReferenceException;

public abstract class AbstractReferenceEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<EntityReference> {
    private Map<EntityType, List<EntityType>> nextAllowedEntityTypes = new HashMap<EntityType, List<EntityType>>(){
        {
            this.put(EntityType.ATTACHMENT, Arrays.asList(EntityType.DOCUMENT));
            this.put(EntityType.DOCUMENT, Arrays.asList(EntityType.SPACE));
            this.put(EntityType.SPACE, Arrays.asList(EntityType.WIKI, EntityType.SPACE));
            this.put(EntityType.WIKI, Collections.emptyList());
            this.put(EntityType.OBJECT, Arrays.asList(EntityType.DOCUMENT));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList(EntityType.OBJECT));
            this.put(EntityType.CLASS_PROPERTY, Arrays.asList(EntityType.DOCUMENT));
            this.put(EntityType.BLOCK, Arrays.asList(EntityType.DOCUMENT, EntityType.OBJECT_PROPERTY));
        }
    };

    @Override
    public EntityReference resolve(EntityReference referenceToResolve, EntityType type, Object ... parameters) {
        EntityReference normalizedReference = referenceToResolve == null ? new EntityReference(this.resolveDefaultValue(type, parameters), type) : (type.ordinal() > referenceToResolve.getType().ordinal() ? new EntityReference(this.resolveDefaultValue(type, parameters), type, referenceToResolve) : referenceToResolve);
        try {
            normalizedReference = this.normalizeReference(normalizedReference, parameters);
        }
        catch (InvalidEntityReferenceException e) {
            throw new InvalidEntityReferenceException("Invalid reference [" + referenceToResolve + "]");
        }
        if (referenceToResolve != null && type.ordinal() < referenceToResolve.getType().ordinal()) {
            normalizedReference = normalizedReference.extractReference(type);
        }
        return normalizedReference;
    }

    private EntityReference normalizeReference(EntityReference referenceToResolve, Object[] parameters) {
        EntityReference normalizedReference;
        EntityReference reference = normalizedReference = referenceToResolve;
        while (reference != null) {
            EntityReference newReference;
            List<EntityType> types = this.nextAllowedEntityTypes.get((Object)reference.getType());
            if (reference.getParent() != null && !types.isEmpty() && !types.contains((Object)reference.getParent().getType())) {
                newReference = new EntityReference(this.resolveDefaultValue(types.get(0), parameters), types.get(0), reference.getParent());
                normalizedReference = normalizedReference.replaceParent(reference.getParent(), newReference);
                reference = newReference;
                continue;
            }
            if (reference.getParent() == null && !types.isEmpty()) {
                newReference = new EntityReference(this.resolveDefaultValue(types.get(0), parameters), types.get(0));
                normalizedReference = normalizedReference.appendParent(newReference);
                reference = newReference;
                continue;
            }
            if (reference.getParent() != null && types.isEmpty()) {
                throw new InvalidEntityReferenceException();
            }
            reference = reference.getParent();
        }
        return normalizedReference;
    }
}

