/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.model.namespace;

import org.xwiki.component.namespace.Namespace;

/**
 * Typed {@link Namespace} for documents.
 * 
 * @version $Id: 8304d207d68e3fa505924806e8963e9e98016856 $
 * @since 9.6RC1
 */
public class DocumentNamespace extends Namespace
{
    /**
     * The type used in those namespaces.
     */
    public static final String TYPE = "document";

    /**
     * @param documentReference the document reference
     */
    public DocumentNamespace(String documentReference)
    {
        super(TYPE, documentReference);
    }
}
