/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultStringEntityReferenceSerializer
extends AbstractStringEntityReferenceSerializer {
    @Inject
    private SymbolScheme symbolScheme;

    public DefaultStringEntityReferenceSerializer() {
    }

    public DefaultStringEntityReferenceSerializer(SymbolScheme symbolScheme) {
        this.symbolScheme = symbolScheme;
    }

    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        EntityType currentType = currentReference.getType();
        EntityReference parentReference = currentReference.getParent();
        if (parentReference != null && representation.length() > 0) {
            Character separator = this.getSymbolScheme().getSeparatorSymbols().get((Object)currentType).get((Object)parentReference.getType());
            if (separator != null) {
                representation.append(separator);
            } else {
                representation.append("???");
            }
        }
        representation.append(StringUtils.replaceEach((String)currentReference.getName(), (String[])this.getSymbolScheme().getSymbolsRequiringEscapes(currentType), (String[])this.getSymbolScheme().getReplacementSymbols(currentType)));
    }

    protected SymbolScheme getSymbolScheme() {
        return this.symbolScheme;
    }
}

