/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class EntityReferenceSet {
    private EntityReferenceEntry includes;
    private EntityReferenceEntry excludes;

    private void add(EntityReference reference, EntityReferenceEntry entry) {
        EntityReferenceEntry currentEntry = entry;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry == entry) {
                while (currentEntry.children != null && currentEntry.getClosestChildren(element.getType()) == null) {
                    currentEntry = currentEntry.add();
                }
            }
            currentEntry = currentEntry.add(element.getType(), element.getName(), element.getParameters());
        }
    }

    public EntityReferenceSet includes(EntityReference reference) {
        if (this.includes == null) {
            this.includes = new EntityReferenceEntry();
        }
        this.add(reference, this.includes);
        return this;
    }

    public EntityReferenceSet excludes(EntityReference reference) {
        if (this.excludes == null) {
            this.excludes = new EntityReferenceEntry();
        }
        this.add(reference, this.excludes);
        return this;
    }

    private boolean matchesInclude(EntityReference reference) {
        if (this.includes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.includes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return true;
            }
            EntityReferenceEntryChildren typedChildren = currentEntry.children.get((Object)element.getType());
            if (typedChildren != null) {
                EntityReferenceEntry nameEntry = typedChildren.children.get(element.getName());
                if (nameEntry == null) {
                    currentEntry = typedChildren.children.get(null);
                    if (currentEntry == null) {
                        return false;
                    }
                } else {
                    currentEntry = nameEntry;
                }
                if (currentEntry.matches(element)) continue;
                return false;
            }
            if (currentEntry.name == null && currentEntry.getClosestChildren(element.getType()) != null) continue;
            return false;
        }
        return true;
    }

    private boolean matchesExclude(EntityReference reference) {
        if (this.excludes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.excludes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return false;
            }
            EntityReferenceEntryChildren typedChildren = currentEntry.children.get((Object)element.getType());
            if (typedChildren == null) continue;
            EntityReferenceEntry nameEntry = typedChildren.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = typedChildren.children.get(null);
                if (currentEntry == null) {
                    return true;
                }
            } else {
                currentEntry = nameEntry;
            }
            if (currentEntry.matches(element)) continue;
            return true;
        }
        return currentEntry.children != null || currentEntry.parameters != null && CollectionUtils.intersection(this.getParametersKeys(currentEntry.parameters), reference.getParameters().keySet()).isEmpty();
    }

    private Set<String> getParametersKeys(List<Map<String, Serializable>> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map<String, Serializable> map : parameters) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public boolean matches(EntityReference reference) {
        return this.matchesInclude(reference) && this.matchesExclude(reference);
    }

    private static class EntityReferenceEntry {
        public EntityType type;
        public String name;
        public List<Map<String, Serializable>> parameters;
        public Map<EntityType, EntityReferenceEntryChildren> children;

        public EntityReferenceEntry() {
        }

        public EntityReferenceEntry(EntityType type, String name) {
            this.type = type;
            this.name = name;
        }

        public EntityReferenceEntry add() {
            return this.add(null, null, null);
        }

        public EntityReferenceEntryChildren getChildren(EntityType entityType, boolean create) {
            EntityReferenceEntryChildren child;
            if (this.children == null) {
                if (!create) {
                    return null;
                }
                this.children = new HashMap<EntityType, EntityReferenceEntryChildren>();
            }
            if ((child = this.children.get((Object)entityType)) == null) {
                if (!create) {
                    return null;
                }
                child = new EntityReferenceEntryChildren();
                child.childrenType = entityType;
                this.children.put(entityType, child);
            }
            return child;
        }

        public EntityReferenceEntryChildren getClosestChildren(EntityType entityType) {
            EntityReferenceEntryChildren typedChildren = this.getChildren(entityType, false);
            if (typedChildren != null) {
                return typedChildren;
            }
            if (this.children == null) {
                return null;
            }
            for (Map.Entry<EntityType, EntityReferenceEntryChildren> entry : this.children.entrySet()) {
                EntityReferenceEntryChildren typedChilrendEntry = entry.getValue();
                if (typedChilrendEntry.childrenType.ordinal() <= entityType.ordinal() || typedChildren != null && typedChildren.childrenType.ordinal() <= typedChilrendEntry.childrenType.ordinal()) continue;
                typedChildren = typedChilrendEntry;
            }
            return typedChildren;
        }

        public EntityReferenceEntry add(EntityType entityType, String entityName, Map<String, Serializable> entityParameters) {
            EntityReferenceEntryChildren child = this.getChildren(entityType, true);
            return child.add(entityName, entityParameters);
        }

        private void addParameters(Map<String, Serializable> entityParameters) {
            if (!entityParameters.isEmpty()) {
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Map<String, Serializable>>();
                }
                this.parameters.add(entityParameters);
            }
        }

        public boolean matches(EntityReference reference) {
            return this.matches(reference.getParameters());
        }

        public boolean matches(Map<String, Serializable> referenceParameters) {
            if (this.parameters == null) {
                return true;
            }
            boolean matches = this.parameters.isEmpty();
            for (Map<String, Serializable> parametersMap : this.parameters) {
                matches |= this.matches(referenceParameters, parametersMap);
            }
            return matches;
        }

        private boolean matches(Map<String, Serializable> referenceParameters, Map<String, Serializable> map) {
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                if (!referenceParameters.containsKey(entry.getKey()) || Objects.equals(entry.getValue(), referenceParameters.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.type != null) {
                builder.append((Object)this.type);
                builder.append(':');
                builder.append(this.name);
            }
            if (this.children != null) {
                builder.append('(');
                builder.append(this.children);
                builder.append(')');
            }
            return builder.toString();
        }
    }

    private static class EntityReferenceEntryChildren {
        public EntityType childrenType;
        public Map<String, EntityReferenceEntry> children;

        private EntityReferenceEntryChildren() {
        }

        public EntityReferenceEntry add(String name, Map<String, Serializable> entityParameters) {
            EntityReferenceEntry entry;
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            if ((entry = this.children.get(name)) == null) {
                entry = new EntityReferenceEntry(this.childrenType, name);
                if (entityParameters != null) {
                    entry.addParameters(entityParameters);
                }
                this.children.put(name, entry);
            } else if (!entry.matches(entityParameters)) {
                entry.addParameters(entityParameters);
            }
            return entry;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)this.childrenType);
            builder.append('(');
            builder.append(this.children);
            return builder.toString();
        }
    }
}

