/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;
import org.xwiki.velocity.VelocityManager;

@Component
@Singleton
public class DefaultNotificationDisplayer
implements NotificationDisplayer {
    private static final String EVENT_BINDING_NAME = "event";
    @Inject
    private TemplateManager templateManager;
    @Inject
    private VelocityManager velocityManager;

    @Override
    public Block renderNotification(CompositeEvent eventNotification) throws NotificationException {
        try {
            this.velocityManager.getCurrentVelocityContext().put(EVENT_BINDING_NAME, (Object)eventNotification);
            String templateName = String.format("notification/%s.vm", eventNotification.getType().replaceAll("\\/", "."));
            Template template = this.templateManager.getTemplate(templateName);
            XDOM xDOM = template != null ? this.templateManager.execute(template) : this.templateManager.execute("notification/default.vm");
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException("Failed to render the notification.", (Throwable)e);
        }
        finally {
            this.velocityManager.getCurrentVelocityContext().remove((Object)EVENT_BINDING_NAME);
        }
    }

    @Override
    public List<String> getSupportedEvents() {
        return Collections.emptyList();
    }
}

