/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.notifiers.email.NotificationEmailInterval;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={IntervalUsersManager.class})
@Singleton
public class IntervalUsersManager {
    private static final int BATCH_SIZE = 100;
    private static final String XWQL_QUERY = "select distinct doc.fullName from Document doc, doc.object(XWiki.XWikiUsers) objUser where objUser.active = 1 and length(objUser.email) > 0 order by doc.fullName";
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    private Map<String, Map<NotificationEmailInterval, List<DocumentReference>>> usersCache = new ConcurrentHashMap<String, Map<NotificationEmailInterval, List<DocumentReference>>>();

    public List<DocumentReference> getUsers(NotificationEmailInterval interval, String wiki) throws QueryException {
        try {
            return this.usersCache.computeIfAbsent(wiki, k -> new ConcurrentHashMap()).computeIfAbsent(interval, k -> this.loadUsers((NotificationEmailInterval)((Object)k), wiki));
        }
        catch (RuntimeException e) {
            throw (QueryException)e.getCause();
        }
    }

    private List<DocumentReference> loadUsers(NotificationEmailInterval targetInterval, String wiki) {
        ArrayList<DocumentReference> userReferences = new ArrayList<DocumentReference>();
        int batchSize = 100;
        int offset = 0;
        while (batchSize == 100) {
            try {
                batchSize = this.loadUsers(targetInterval, wiki, offset, userReferences);
            }
            catch (QueryException e) {
                throw new RuntimeException(e);
            }
            offset += 100;
        }
        return userReferences;
    }

    private int loadUsers(NotificationEmailInterval targetInterval, String wiki, int offset, List<DocumentReference> userReferences) throws QueryException {
        Query query = this.queryManager.createQuery(XWQL_QUERY, "xwql");
        query.setWiki(wiki);
        query.setLimit(100);
        query.setOffset(offset);
        List users = query.execute();
        if (!users.isEmpty()) {
            WikiReference wikiReference = new WikiReference(wiki);
            DocumentReference classReference = new DocumentReference(wiki, Arrays.asList("XWiki", "Notifications", "Code"), "NotificationEmailPreferenceClass");
            for (String user : users) {
                DocumentReference userReference = this.referenceResolver.resolve((Object)user, new Object[]{wikiReference});
                Object userInterval = this.documentAccessBridge.getProperty(userReference, classReference, "interval");
                if (!this.isDefaultInterval(userInterval, targetInterval) && !this.isSameInterval(userInterval, targetInterval)) continue;
                userReferences.add((DocumentReference)this.referenceFactory.getReference((EntityReference)userReference));
            }
        }
        return users.size();
    }

    private boolean isDefaultInterval(Object interval, NotificationEmailInterval targetInterval) {
        return StringUtils.isBlank((CharSequence)((String)interval)) && targetInterval == NotificationEmailInterval.DAILY;
    }

    private boolean isSameInterval(Object interval, NotificationEmailInterval targetInterval) {
        if (interval instanceof String) {
            String stringInterval = (String)interval;
            return StringUtils.isNotBlank((CharSequence)stringInterval) && targetInterval == NotificationEmailInterval.valueOf(StringUtils.upperCase((String)stringInterval));
        }
        return false;
    }

    public void invalidateWiki(String wikiId) {
        this.usersCache.remove(wikiId);
    }

    public void invalidateUser(DocumentReference userReference) {
        this.invalidateWiki(userReference.getWikiReference().getName());
    }
}

