/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.mail.Session;
import org.quartz.JobExecutionException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.SessionFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.notifiers.internal.email.NotificationUserIterator;
import org.xwiki.notifications.notifiers.internal.email.PeriodicMimeMessageIterator;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={NotificationEmailSender.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class NotificationEmailSender {
    @Inject
    private MailSender mailSender;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    @Named(value="database")
    private Provider<MailListener> mailListenerProvider;
    @Inject
    private Provider<PeriodicMimeMessageIterator> notificationMimeMessageIteratorProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public void sendEmails(Date fromDate, NotificationUserIterator notificationUserIterator) throws JobExecutionException {
        HashMap<String, Object> emailFactoryParameters = new HashMap<String, Object>();
        DocumentReference templateReference = new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), Arrays.asList("XWiki", "Notifications"), "MailTemplate");
        PeriodicMimeMessageIterator periodicMimeMessageIterator = (PeriodicMimeMessageIterator)this.notificationMimeMessageIteratorProvider.get();
        periodicMimeMessageIterator.initialize(notificationUserIterator, emailFactoryParameters, fromDate, templateReference);
        Session session = this.sessionFactory.create(Collections.emptyMap());
        MailListener mailListener = (MailListener)this.mailListenerProvider.get();
        this.mailSender.sendAsynchronously((Iterable)periodicMimeMessageIterator, session, mailListener);
    }
}

