/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.rss;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndPersonImpl;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.rss.NotificationRSSRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultNotificationRSSRenderer
implements NotificationRSSRenderer {
    public static final String COMPOSITE_EVENT_BUILDING_NAME = "event";
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer blockRenderer;

    @Override
    public SyndEntry renderNotification(CompositeEvent eventNotification) throws NotificationException {
        SyndEntryImpl entry = new SyndEntryImpl();
        SyndContentImpl entryDescription = new SyndContentImpl();
        ArrayList<SyndPersonImpl> eventAuthors = new ArrayList<SyndPersonImpl>();
        for (DocumentReference author : eventNotification.getUsers()) {
            SyndPersonImpl person = new SyndPersonImpl();
            person.setName(author.getName());
            eventAuthors.add(person);
        }
        entry.setAuthors(eventAuthors);
        entry.setUri(String.join((CharSequence)"-", eventNotification.getEventIds()));
        entry.setTitle(this.contextualLocalizationManager.getTranslationPlain(((Event)eventNotification.getEvents().get(0)).getTitle(), new Object[]{((Event)eventNotification.getEvents().get(0)).getDocumentTitle()}));
        try {
            this.scriptContextManager.getCurrentScriptContext().setAttribute(COMPOSITE_EVENT_BUILDING_NAME, eventNotification, 100);
            Template template = this.templateManager.getTemplate(String.format("notification/rss/%s.vm", eventNotification.getType().replaceAll("\\/", ".")));
            if (template == null) {
                template = this.templateManager.getTemplate("notification/rss/default.vm");
            }
            XDOM descriptionXDOM = this.templateManager.execute(template);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.blockRenderer.render((Block)descriptionXDOM, (WikiPrinter)printer);
            entryDescription.setType("text/html");
            entryDescription.setValue(printer.toString());
            entry.setDescription((SyndContent)entryDescription);
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to render the description of the event [%s].", eventNotification), (Throwable)e);
        }
        finally {
            this.scriptContextManager.getCurrentScriptContext().removeAttribute(COMPOSITE_EVENT_BUILDING_NAME, 100);
        }
        entry.setUpdatedDate((Date)eventNotification.getDates().get(0));
        return entry;
    }
}

