/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractWikiNotificationRendererComponentBuilder
implements WikiBaseObjectComponentBuilder {
    @Inject
    protected AuthorizationManager authorizationManager;

    public List<WikiComponent> buildComponents(BaseObject baseObject) throws WikiComponentException {
        try {
            XWikiDocument parentDocument = baseObject.getOwnerDocument();
            this.checkRights(parentDocument.getDocumentReference(), parentDocument.getAuthorReference());
            return Arrays.asList(this.instantiateComponent(parentDocument.getAuthorReference(), baseObject));
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Unable to build the WikiNotificationDisplayer wiki component for [%s].", baseObject), (Throwable)e);
        }
    }

    protected abstract WikiComponent instantiateComponent(DocumentReference var1, BaseObject var2) throws NotificationException;

    protected void checkRights(DocumentReference documentReference, DocumentReference authorReference) throws NotificationException {
        if (!this.authorizationManager.hasAccess(Right.ADMIN, authorReference, (EntityReference)documentReference.getWikiReference())) {
            throw new NotificationException("Registering custom Notification Displayers requires wiki administration rights.");
        }
    }
}

