/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.api.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.NotificationEmailRenderer;
import org.xwiki.notifications.notifiers.internal.email.EventsSorter;
import org.xwiki.notifications.notifiers.internal.email.LogoAttachmentExtractor;
import org.xwiki.notifications.notifiers.internal.email.MailTemplateImageAttachmentsExtractor;
import org.xwiki.notifications.notifiers.internal.email.NotificationUserIterator;
import org.xwiki.notifications.notifiers.internal.email.UserAvatarAttachmentExtractor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractMimeMessageIterator
implements Iterator<MimeMessage>,
Iterable<MimeMessage> {
    private static final String EVENTS = "events";
    private static final String HTML_EVENTS = "htmlEvents";
    private static final String PLAIN_TEXT_EVENTS = "plainTextEvents";
    private static final String SORTED_EVENTS = "sortedEvents";
    private static final String EMAIL_PROPERTY = "email";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String VELOCITY_VARIABLES = "velocityVariables";
    private static final String ERROR_MESSAGE = "Failed to generate an email for the user [{}].";
    private static final String ATTACHMENTS = "attachments";
    private static final String EMAIL_USER = "emailUser";
    @Inject
    protected Logger logger;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="template")
    private MimeMessageFactory<MimeMessage> factory;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private NotificationEmailRenderer defaultNotificationEmailRenderer;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private MailSenderConfiguration mailSenderConfiguration;
    @Inject
    private UserAvatarAttachmentExtractor userAvatarAttachmentExtractor;
    @Inject
    private LogoAttachmentExtractor logoAttachmentExtractor;
    @Inject
    private MailTemplateImageAttachmentsExtractor mailTemplateImageAttachmentsExtractor;
    private NotificationUserIterator userIterator;
    private Map<String, Object> factoryParameters = new HashMap<String, Object>();
    private DocumentReference templateReference;
    private List<CompositeEvent> currentEvents = Collections.emptyList();
    private DocumentReference currentUser;
    private InternetAddress currentUserEmail;
    private boolean hasNext;

    protected void initialize(NotificationUserIterator userIterator, Map<String, Object> factoryParameters, DocumentReference templateReference) {
        this.userIterator = userIterator;
        this.factoryParameters = factoryParameters;
        this.templateReference = templateReference;
        this.computeNext();
    }

    protected abstract List<CompositeEvent> retrieveCompositeEventList(DocumentReference var1) throws NotificationException;

    protected void computeNext() {
        this.currentEvents = Collections.emptyList();
        this.currentUserEmail = null;
        while ((this.currentEvents.isEmpty() || this.currentUserEmail == null) && this.userIterator.hasNext()) {
            this.currentUser = this.userIterator.next();
            try {
                this.currentUserEmail = new InternetAddress(this.getUserEmail(this.currentUser));
            }
            catch (AddressException e) {
                continue;
            }
            try {
                this.currentEvents = this.retrieveCompositeEventList(this.currentUser);
            }
            catch (NotificationException e) {
                this.logger.error(ERROR_MESSAGE, (Object)this.currentUser, (Object)e);
            }
        }
        this.hasNext = this.currentUserEmail != null && !this.currentEvents.isEmpty();
    }

    private void updateFactoryParameters() throws NotificationException, AddressException {
        this.getAttachments().clear();
        this.handleEvents();
        this.handleWikiLogo();
        this.handleImageAttachmentsFromTemplate();
        try {
            this.factoryParameters.put(FROM, new InternetAddress(this.mailSenderConfiguration.getFromAddress()));
        }
        catch (NullPointerException | AddressException e) {
            this.logger.warn("No default email address is configured in the administration.");
        }
        this.factoryParameters.put(TO, this.currentUserEmail);
    }

    private void handleImageAttachmentsFromTemplate() throws NotificationException {
        Collection<Attachment> attachments = this.getAttachments();
        try {
            attachments.addAll(this.mailTemplateImageAttachmentsExtractor.getImages(this.templateReference));
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to get the attachments of the template [%s].", this.templateReference), (Throwable)e);
        }
    }

    private void handleEvents() throws NotificationException {
        String usedId = (String)this.serializer.serialize((EntityReference)this.currentUser, new Object[0]);
        ArrayList<String> htmlEvents = new ArrayList<String>();
        ArrayList<String> plainTextEvents = new ArrayList<String>();
        EventsSorter eventsSorter = new EventsSorter();
        for (CompositeEvent event : this.currentEvents) {
            String html = this.defaultNotificationEmailRenderer.renderHTML(event, usedId);
            String plainText = this.defaultNotificationEmailRenderer.renderPlainText(event, usedId);
            htmlEvents.add(html);
            plainTextEvents.add(plainText);
            eventsSorter.add(event, html, plainText);
        }
        Map<String, Object> velocityVariables = this.getVelocityVariables();
        velocityVariables.put(EMAIL_USER, usedId);
        velocityVariables.put(EVENTS, this.currentEvents);
        velocityVariables.put(HTML_EVENTS, htmlEvents);
        velocityVariables.put(PLAIN_TEXT_EVENTS, plainTextEvents);
        velocityVariables.put(SORTED_EVENTS, eventsSorter.sort());
        this.handleAvatars();
    }

    private void handleWikiLogo() {
        try {
            this.getAttachments().add(this.logoAttachmentExtractor.getLogo());
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the logo.", (Throwable)e);
        }
    }

    private Collection<Attachment> getAttachments() {
        Object attachments = this.factoryParameters.get(ATTACHMENTS);
        if (attachments != null) {
            return (Collection)attachments;
        }
        ArrayList<Attachment> newList = new ArrayList<Attachment>();
        this.factoryParameters.put(ATTACHMENTS, newList);
        return newList;
    }

    private void handleAvatars() {
        HashSet userAvatars = new HashSet();
        for (CompositeEvent event : this.currentEvents) {
            userAvatars.addAll(event.getUsers());
        }
        Collection<Attachment> attachments = this.getAttachments();
        for (DocumentReference userAvatar : userAvatars) {
            try {
                attachments.add(this.userAvatarAttachmentExtractor.getUserAvatar(userAvatar, 32));
            }
            catch (Exception e) {
                this.logger.warn("Failed to add the avatar of [{}] in the email.", (Object)userAvatar, (Object)e);
            }
        }
    }

    private Map<String, Object> getVelocityVariables() {
        HashMap velocityVariables = this.factoryParameters.get(VELOCITY_VARIABLES);
        if (velocityVariables == null) {
            velocityVariables = new HashMap();
            this.factoryParameters.put(VELOCITY_VARIABLES, velocityVariables);
        }
        return velocityVariables;
    }

    private String getUserEmail(DocumentReference user) {
        return (String)this.documentAccessBridge.getProperty(user, new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), "XWiki", "XWikiUsers"), 0, EMAIL_PROPERTY);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public MimeMessage next() {
        MimeMessage message = null;
        try {
            this.updateFactoryParameters();
            message = (MimeMessage)this.factory.createMessage((Object)this.templateReference, this.factoryParameters);
        }
        catch (Exception e) {
            this.logger.error(ERROR_MESSAGE, (Object)this.currentUser, (Object)e);
        }
        this.computeNext();
        return message;
    }

    @Override
    public Iterator<MimeMessage> iterator() {
        return this;
    }
}

