/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;

public class SortedEvent {
    private CompositeEvent event;
    private String html;
    private String plainText;
    private List<SortedEvent> eventsWithTheSameDocument = new ArrayList<SortedEvent>();
    private List<SortedEvent> children = new ArrayList<SortedEvent>();

    public SortedEvent(CompositeEvent event, String html, String plainText) {
        this.event = event;
        this.html = html;
        this.plainText = plainText;
    }

    public CompositeEvent getEvent() {
        return this.event;
    }

    public String getHtml() {
        return this.html;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public void addChild(SortedEvent event) {
        this.children.add(event);
    }

    public List<SortedEvent> getChildren() {
        Collections.sort(this.children, Comparator.comparing(e -> e.getEvent().getDocument()));
        return this.children;
    }

    public boolean isParent(SortedEvent sortedEvent) {
        DocumentReference document = this.getDocument();
        return document != null && !document.equals((Object)sortedEvent.getDocument()) && document.getName().equals("WebHome") && sortedEvent.getDocument().hasParent((EntityReference)document.getLastSpaceReference());
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<SortedEvent> getEventsWithTheSameDocument() {
        return this.eventsWithTheSameDocument;
    }

    public void addEventWithTheSameDocument(SortedEvent event) {
        this.eventsWithTheSameDocument.add(event);
        if (event.hasChildren()) {
            this.children.addAll(event.children);
            event.children.clear();
        }
    }

    public DocumentReference getDocument() {
        return this.event.getDocument();
    }

    public Date getDate() {
        return this.event.getDate();
    }
}

