/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;

@Component(roles={UserAvatarAttachmentExtractor.class})
@Singleton
public class UserAvatarAttachmentExtractor {
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;

    public Attachment getUserAvatar(DocumentReference userReference, int size) throws Exception {
        InputStream imageStream = null;
        try {
            imageStream = this.getUserAvatarStream(userReference);
            XWikiAttachment fakeAttachment = new XWikiAttachment();
            XWikiAttachmentContent content = new XWikiAttachmentContent(fakeAttachment);
            this.resizeImage(imageStream, size, content.getContentOutputStream());
            fakeAttachment.setAttachment_content(content);
            fakeAttachment.setFilename(String.format("%s.jpg", userReference != null ? userReference.getName() : "XWikiGuest"));
            Attachment attachment = new Attachment(null, fakeAttachment, (XWikiContext)this.xwikiContextProvider.get());
            return attachment;
        }
        catch (Exception e) {
            throw new Exception(String.format("Failed to resize the avatar of [%s].", userReference), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    private InputStream getUserAvatarStream(DocumentReference userReference) {
        if (userReference != null) {
            try {
                XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
                XWiki xwiki = context.getWiki();
                XWikiDocument userProfileDocument = xwiki.getDocument(userReference, context);
                DocumentReference usersClassReference = xwiki.getUserClass(context).getDocumentReference();
                String avatarFileName = userProfileDocument.getStringValue(usersClassReference, "avatar");
                XWikiAttachment attachment = userProfileDocument.getAttachment(avatarFileName);
                if (attachment != null && attachment.isImage(context)) {
                    return attachment.getContentInputStream(context);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to get the avatar of [{}]. Fallback to default one.", (Object)userReference, (Object)e);
            }
        }
        return this.getDefaultAvatarStream();
    }

    private InputStream getDefaultAvatarStream() {
        return this.environment.getResourceAsStream("/resources/icons/xwiki/noavatar.png");
    }

    private void resizeImage(InputStream imageFileInputStream, int size, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(imageFileInputStream);
        int sourceWidth = bufferedImage.getWidth();
        int sourceHeight = bufferedImage.getHeight();
        int smallestDimension = Math.min(sourceWidth, sourceHeight);
        Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).sourceRegion(sourceWidth / 2 - smallestDimension / 2, sourceHeight / 2 - smallestDimension / 2, smallestDimension, smallestDimension).forceSize(size, size).outputFormat("jpg").toOutputStream(outputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

