/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.NotificationEmailRenderer;
import org.xwiki.notifications.notifiers.internal.AbstractWikiNotificationRenderer;
import org.xwiki.notifications.notifiers.internal.email.EmailTemplateRenderer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

public class WikiEmailNotificationRenderer
extends AbstractWikiNotificationRenderer
implements NotificationEmailRenderer {
    private EmailTemplateRenderer emailTemplateRenderer;
    private Template htmlTemplate;
    private Template plainTextTemplate;
    private Template emailSubjectTemplate;

    public WikiEmailNotificationRenderer(DocumentReference authorReference, TemplateManager templateManager, ScriptContextManager scriptContextManager, ComponentManager componentManager, BaseObject baseObject) throws NotificationException {
        super(authorReference, templateManager, scriptContextManager, componentManager, baseObject);
        try {
            this.emailTemplateRenderer = (EmailTemplateRenderer)componentManager.getInstance(EmailTemplateRenderer.class);
        }
        catch (ComponentLookupException e) {
            throw new NotificationException("Failed to create a new instance of WikiEmailNotificationRenderer.", (Throwable)e);
        }
        this.htmlTemplate = this.extractTemplate(baseObject, "htmlTemplate");
        this.plainTextTemplate = this.extractTemplate(baseObject, "plainTextTemplate");
        this.emailSubjectTemplate = this.extractTemplate(baseObject, "emailSubject");
    }

    public String renderHTML(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.htmlTemplate != null) {
            return this.emailTemplateRenderer.renderHTML(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.htmlTemplate, Syntax.XHTML_1_0));
        }
        return null;
    }

    public String renderPlainText(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.plainTextTemplate != null) {
            return this.emailTemplateRenderer.renderPlainText(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.plainTextTemplate, Syntax.PLAIN_1_0));
        }
        return null;
    }

    public String generateEmailSubject(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.emailSubjectTemplate != null) {
            return this.emailTemplateRenderer.renderPlainText(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.emailSubjectTemplate, Syntax.PLAIN_1_0));
        }
        return null;
    }

    public Type getRoleType() {
        return NotificationEmailRenderer.class;
    }
}

