/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.notifiers.internal.email.AbstractMimeMessageIterator;
import org.xwiki.notifications.notifiers.internal.email.NotificationUserIterator;
import org.xwiki.notifications.notifiers.internal.email.live.LiveMimeMessageIterator;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultLiveMimeMessageIterator
extends AbstractMimeMessageIterator
implements LiveMimeMessageIterator {
    private CompositeEvent compositeEvent;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private AuthorizationManager authorizationManager;

    public void initialize(NotificationUserIterator userIterator, Map<String, Object> factoryParameters, CompositeEvent event, DocumentReference templateReference) {
        this.compositeEvent = event;
        super.initialize(userIterator, factoryParameters, templateReference);
    }

    @Override
    protected List<CompositeEvent> retrieveCompositeEventList(DocumentReference user) throws NotificationException {
        CompositeEvent resultCompositeEvent = new CompositeEvent(this.compositeEvent);
        if (this.canAccessEvent(user, resultCompositeEvent) && (this.hasCorrespondingNotificationPreference(user, resultCompositeEvent) || this.isTriggeredByAFollowedUser(user, resultCompositeEvent))) {
            ArrayList<NotificationFilter> filters = new ArrayList<NotificationFilter>(this.notificationFilterManager.getAllFilters(user, true));
            Collections.sort(filters);
            Iterator it = resultCompositeEvent.getEvents().iterator();
            while (it.hasNext()) {
                Event event = (Event)it.next();
                if (!this.isEventFiltered(filters, event, user)) continue;
                it.remove();
            }
            if (resultCompositeEvent.getEvents().size() == 0) {
                return Collections.emptyList();
            }
            return Collections.singletonList(resultCompositeEvent);
        }
        return Collections.emptyList();
    }

    private boolean isEventFiltered(List<NotificationFilter> filters, Event event, DocumentReference user) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(user);
        for (NotificationFilter filter : filters) {
            NotificationFilter.FilterPolicy policy = filter.filterEvent(event, user, filterPreferences, NotificationFormat.EMAIL);
            switch (policy) {
                case FILTER: {
                    return true;
                }
                case KEEP: {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean hasCorrespondingNotificationPreference(DocumentReference user, CompositeEvent compositeEvent) {
        try {
            for (NotificationPreference notificationPreference : this.notificationPreferenceManager.getAllPreferences(user)) {
                if (!notificationPreference.getFormat().equals((Object)NotificationFormat.EMAIL) || !notificationPreference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE) || !notificationPreference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE).equals(compositeEvent.getType())) continue;
                return notificationPreference.isNotificationEnabled();
            }
        }
        catch (NotificationException e) {
            this.logger.warn("Unable to retrieve the notifications preferences of [{}]: [{}]", (Object)user, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return false;
    }

    private boolean isTriggeredByAFollowedUser(DocumentReference user, CompositeEvent compositeEvent) {
        try {
            return this.notificationFilterPreferenceManager.getFilterPreferences(user).stream().anyMatch(fp -> this.isUserFilterPreference((NotificationFilterPreference)fp) && this.matchUser((NotificationFilterPreference)fp, compositeEvent));
        }
        catch (NotificationException e) {
            return false;
        }
    }

    private boolean canAccessEvent(DocumentReference user, CompositeEvent event) {
        DocumentReference document = event.getDocument();
        return document != null && this.authorizationManager.hasAccess(Right.VIEW, user, (EntityReference)document);
    }

    private boolean isUserFilterPreference(NotificationFilterPreference filterPreference) {
        return this.matchFilter(filterPreference) && this.matchFormat(filterPreference, NotificationFormat.EMAIL) && this.matchFilterType(filterPreference, NotificationFilterType.INCLUSIVE) && this.matchAllEvents(filterPreference);
    }

    private boolean matchUser(NotificationFilterPreference filterPreference, CompositeEvent event) {
        return event.getUsers().contains(this.referenceResolver.resolve((Object)filterPreference.getUser(), new Object[0]));
    }

    private boolean matchFormat(NotificationFilterPreference filterPreference, NotificationFormat format) {
        return format == null || filterPreference.getNotificationFormats().contains(format);
    }

    private boolean matchFilter(NotificationFilterPreference pref) {
        return pref.isEnabled() && "eventUserNotificationFilter".equals(pref.getFilterName());
    }

    private boolean matchFilterType(NotificationFilterPreference pref, NotificationFilterType filterType) {
        return pref.getFilterType() == filterType;
    }

    private boolean matchAllEvents(NotificationFilterPreference filterPreference) {
        return filterPreference.getEventTypes().isEmpty();
    }
}

