/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.notifications.preferences.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.notifications.preferences.internal.event.NotificationPreferenceAddedEvent;
import org.xwiki.notifications.preferences.internal.event.NotificationPreferenceDeletedEvent;
import org.xwiki.notifications.preferences.internal.event.NotificationPreferenceUpdatedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObjectReference;

/**
 * A listener used to generate notification preference event when corresponding xobjects are manipulated.
 * 
 * @version $Id: 53fc69e0ea68af8e029ea8347c9531c88ae6d41f $
 * @since 10.11.4
 * @since 11.2
 */
@Component
@Singleton
@Named(NotificationPreferenceEventGeneratorListener.NAME)
public class NotificationPreferenceEventGeneratorListener extends AbstractEventListener
{
    /**
     * The name of the listener.
     */
    public static final String NAME = "NotificationPreferenceEventGeneratorListener";

    private static final RegexEntityReference REFERENCE =
        BaseObjectReference.any(DefaultModelBridge.NOTIFICATION_PREFERENCE_CLASS_STRING);

    @Inject
    private ObservationManager observation;

    /**
     * The default constructor.
     */
    public NotificationPreferenceEventGeneratorListener()
    {
        super(NAME, new XObjectAddedEvent(REFERENCE), new XObjectUpdatedEvent(REFERENCE),
            new XObjectDeletedEvent(REFERENCE));
    }

    @Override
    public void onEvent(Event event, Object source, Object data)
    {
        if (event instanceof XObjectAddedEvent) {
            this.observation.notify(new NotificationPreferenceAddedEvent(), null);
        } else if (event instanceof XObjectUpdatedEvent) {
            this.observation.notify(new NotificationPreferenceUpdatedEvent(), null);
        } else if (event instanceof XObjectDeletedEvent) {
            this.observation.notify(new NotificationPreferenceDeletedEvent(), null);
        }
    }
}
