/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import com.rometools.rome.io.SyndFeedOutput;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterProperty;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.notifiers.rss.NotificationRSSManager;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.rest.NotificationsResource;
import org.xwiki.notifications.rest.internal.InternalNotificationPreference;
import org.xwiki.notifications.rest.internal.InternalNotificationsRenderer;
import org.xwiki.notifications.rest.internal.NotificationEventExecutor;
import org.xwiki.notifications.rest.internal.TagNotificationFilterPreference;
import org.xwiki.notifications.rest.internal.UsersParameterHandler;
import org.xwiki.notifications.rest.model.Notifications;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.rest.XWikiResource;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="org.xwiki.notifications.rest.internal.DefaultNotificationsResource")
public class DefaultNotificationsResource
extends XWikiResource
implements NotificationsResource {
    private static final String FIELD_SEPARATOR = ",";
    private static final String TRUE = "true";
    @Inject
    private ParametrizedNotificationManager newNotificationManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private InternalNotificationsRenderer notificationsRenderer;
    @Inject
    private EntityReferenceResolver<String> entityReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeEntityReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private UsersParameterHandler usersParameterHandler;
    @Inject
    private NotificationRSSManager notificationRSSManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NotificationEventExecutor executor;

    @Override
    public Response getNotifications(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki, String async, String asyncId) throws Exception {
        Response.ResponseBuilder response;
        Object result = this.getCompositeEvents(useUserPreferences, userId, untilDate, blackList, pages, spaces, wikis, users, this.toMaxCount(maxCount, 21), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, async, asyncId, false, false);
        if (result instanceof String) {
            response = Response.status((Response.Status)Response.Status.ACCEPTED);
            response.entity(Collections.singletonMap("asyncId", result));
        } else {
            XWikiContext xcontext = this.getXWikiContext();
            xcontext.setURLFactory(xcontext.getWiki().getURLFactoryService().createURLFactory(0, xcontext));
            Notifications notifications = new Notifications(this.notificationsRenderer.renderNotifications((List)result, userId, TRUE.equals(displayReadStatus)));
            response = Response.ok((Object)notifications);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        response.cacheControl(cacheControl);
        return response.build();
    }

    private int toMaxCount(String maxCount, int defaultMaxCount) {
        return NumberUtils.toInt((String)maxCount, (int)defaultMaxCount);
    }

    private Object getCompositeEvents(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, int maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki, String async, String asyncId, boolean onlyUnread, boolean count) throws Exception {
        Object result = null;
        if (asyncId != null && (result = this.executor.popAsync(asyncId)) == null) {
            result = asyncId;
        }
        if (result == null) {
            String cacheKey = this.createCacheKey(useUserPreferences, userId, untilDate, blackList, pages, spaces, wikis, users, maxCount, displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, onlyUnread);
            result = this.executor.submit(cacheKey, () -> this.getCompositeEvents(useUserPreferences, userId, untilDate, blackList, pages, spaces, wikis, users, maxCount, displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, onlyUnread), Boolean.parseBoolean(async), count);
        }
        return result;
    }

    @Override
    public Response getNotificationsCount(String useUserPreferences, String userId, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki, String async, String asyncId) throws Exception {
        Response.ResponseBuilder response;
        XWikiUser xWikiUser = this.getXWikiContext().getWiki().getAuthService().checkAuth(this.getXWikiContext());
        if (xWikiUser == null) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        } else {
            Object result = this.getCompositeEvents(useUserPreferences, userId, null, null, pages, spaces, wikis, users, this.toMaxCount(maxCount, 21), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, async, asyncId, true, true);
            if (result instanceof String) {
                response = Response.status((Response.Status)Response.Status.ACCEPTED);
                response.entity(Collections.singletonMap("asyncId", result));
            } else {
                response = Response.ok(Collections.singletonMap("unread", result));
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            response.cacheControl(cacheControl);
        }
        return response.build();
    }

    @Override
    public String getNotificationsRSS(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki) throws Exception {
        XWikiUser xWikiUser = this.getXWikiContext().getWiki().getAuthService().checkAuth(this.getXWikiContext());
        DocumentReference userIdDoc = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        if (xWikiUser == null || !userIdDoc.equals((Object)xWikiUser.getUserReference())) {
            this.getXWikiContext().getResponse().sendError(401);
            return null;
        }
        List events = (List)this.getCompositeEvents(useUserPreferences, userId, untilDate, blackList, pages, spaces, wikis, users, this.toMaxCount(maxCount, 10), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, null, null, false, false);
        SyndFeedOutput output = new SyndFeedOutput();
        return output.outputString(this.notificationRSSManager.renderFeed(events));
    }

    @Override
    public Response postNotifications() throws Exception {
        XWikiRequest request = this.getXWikiContext().getRequest();
        return this.getNotifications(request.get("useUserPreferences"), request.get("userId"), request.get("untilDate"), request.get("blackList"), request.get("pages"), request.get("spaces"), request.get("wikis"), request.get("users"), request.get("count"), request.get("displayOwnEvents"), request.get("displayMinorEvents"), request.get("displaySystemEvents"), request.get("displayReadEvents"), request.get("displayReadStatus"), request.get("tags"), request.get("currentWiki"), request.get("async"), request.get("asyncId"));
    }

    private String createCacheKey(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, int maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki, boolean onlyUnread) {
        StringBuilder cacheKeyBuilder = new StringBuilder();
        this.addCacheKeyElement(cacheKeyBuilder, useUserPreferences);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, userId);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, untilDate);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, blackList);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, pages);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, spaces);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, wikis);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, users);
        cacheKeyBuilder.append('/');
        cacheKeyBuilder.append(maxCount);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, displayOwnEvents);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, displayMinorEvents);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, displaySystemEvents);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, displayReadEvents);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, tags);
        cacheKeyBuilder.append('/');
        this.addCacheKeyElement(cacheKeyBuilder, currentWiki);
        cacheKeyBuilder.append('/');
        cacheKeyBuilder.append(onlyUnread);
        return cacheKeyBuilder.toString();
    }

    private void addCacheKeyElement(StringBuilder cacheKeyBuilder, String value) {
        if (value != null) {
            cacheKeyBuilder.append(value.length());
            cacheKeyBuilder.append(value);
        }
    }

    private List<CompositeEvent> getCompositeEvents(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, int maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki, boolean onlyUnread) throws NotificationException, EventStreamException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = maxCount;
        parameters.onlyUnread = onlyUnread;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)blackList)) {
            parameters.blackList.addAll(Arrays.asList(blackList.split(FIELD_SEPARATOR)));
        }
        if (StringUtils.isNotBlank((CharSequence)untilDate)) {
            parameters.endDate = new Date(Long.parseLong(untilDate));
        }
        if (TRUE.equals(useUserPreferences)) {
            this.useUserPreferences(parameters);
        } else {
            this.dontUseUserPreferences(pages, spaces, wikis, users, parameters, displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki);
        }
        return this.getCompositeEvents(parameters);
    }

    private void dontUseUserPreferences(String pages, String spaces, String wikis, String users, NotificationParameters parameters, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki) throws NotificationException, EventStreamException {
        ArrayList<String> excludedFilters = new ArrayList<String>();
        if (TRUE.equals(displayOwnEvents)) {
            excludedFilters.add("ownEventsNotificationFilter");
        }
        if (TRUE.equals(displayMinorEvents)) {
            excludedFilters.add("minorEventAlertNotificationFilter");
        }
        if (TRUE.equals(displaySystemEvents)) {
            excludedFilters.add("systemUserNotificationFilter");
        }
        if (TRUE.equals(displayReadEvents)) {
            excludedFilters.add("eventReadAlertFilter");
        }
        parameters.filters = this.notificationFilterManager.getAllFilters(true).stream().filter(filter -> !excludedFilters.contains(filter.getName())).collect(Collectors.toList());
        this.enableAllEventTypes(parameters);
        this.handlePagesParameter(pages, parameters, currentWiki);
        this.handleSpacesParameter(spaces, parameters, currentWiki);
        this.handleWikisParameter(wikis, parameters, currentWiki);
        this.handleSubwikiWithoutLocationParameters(parameters, pages, spaces, wikis, currentWiki);
        this.usersParameterHandler.handleUsersParameter(users, parameters);
        this.handleTagsParameter(parameters, tags, currentWiki);
    }

    private void useUserPreferences(NotificationParameters parameters) throws NotificationException {
        if (parameters.user != null) {
            parameters.preferences = this.notificationPreferenceManager.getPreferences(parameters.user, true, parameters.format);
            parameters.filters = this.notificationFilterManager.getAllFilters(parameters.user, true);
            parameters.filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(parameters.user);
        }
    }

    private List<CompositeEvent> getCompositeEvents(NotificationParameters parameters) throws NotificationException {
        return this.newNotificationManager.getEvents(parameters);
    }

    private void handlePagesParameter(String pages, NotificationParameters parameters, String currentWiki) {
        this.handleLocationParameter(pages, parameters, NotificationFilterProperty.PAGE, currentWiki);
    }

    private void handleSpacesParameter(String spaces, NotificationParameters parameters, String currentWiki) {
        this.handleLocationParameter(spaces, parameters, NotificationFilterProperty.SPACE, currentWiki);
    }

    private void handleWikisParameter(String wikis, NotificationParameters parameters, String currentWiki) {
        this.handleLocationParameter(wikis, parameters, NotificationFilterProperty.WIKI, currentWiki);
    }

    private void handleLocationParameter(String locations, NotificationParameters parameters, NotificationFilterProperty property, String currentWiki) {
        if (StringUtils.isNotBlank((CharSequence)locations)) {
            HashSet<NotificationFormat> formats = new HashSet<NotificationFormat>();
            formats.add(NotificationFormat.ALERT);
            String[] locationArray = locations.split(FIELD_SEPARATOR);
            for (int i = 0; i < locationArray.length; ++i) {
                DefaultNotificationFilterPreference pref = new DefaultNotificationFilterPreference();
                pref.setId(String.format("%s_%s_%s", "scopeNotificationFilter", property, i));
                pref.setEnabled(true);
                pref.setFilterName("scopeNotificationFilter");
                pref.setFilterType(NotificationFilterType.INCLUSIVE);
                pref.setNotificationFormats(formats);
                pref.setProviderHint("REST");
                switch (property) {
                    case WIKI: {
                        pref.setWiki(locationArray[i]);
                        break;
                    }
                    case SPACE: {
                        pref.setPage(this.makeReferenceAbsolute(locationArray[i], EntityType.SPACE, currentWiki));
                        break;
                    }
                    case PAGE: {
                        pref.setPageOnly(this.makeReferenceAbsolute(locationArray[i], EntityType.PAGE, currentWiki));
                        break;
                    }
                }
                parameters.filterPreferences.add(new ScopeNotificationFilterPreference((NotificationFilterPreference)pref, this.entityReferenceResolver));
            }
        }
    }

    private String makeReferenceAbsolute(String entityRefStr, EntityType entityType, String currentWiki) {
        EntityReference entityRef = this.relativeEntityReferenceResolver.resolve((Object)entityRefStr, entityType, new Object[0]);
        if (entityRef.extractReference(EntityType.WIKI) == null) {
            entityRef = this.entityReferenceResolver.resolve((Object)entityRefStr, entityType, new Object[]{new EntityReference(currentWiki, EntityType.WIKI)});
        }
        return (String)this.entityReferenceSerializer.serialize(entityRef, new Object[0]);
    }

    private void enableAllEventTypes(NotificationParameters parameters) throws EventStreamException {
        parameters.preferences.clear();
        for (RecordableEventDescriptor descriptor : this.recordableEventDescriptorManager.getRecordableEventDescriptors(true)) {
            parameters.preferences.add(new InternalNotificationPreference(descriptor));
        }
    }

    private void handleTagsParameter(NotificationParameters parameters, String tags, String currentWiki) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            String[] tagArray = tags.split(FIELD_SEPARATOR);
            for (int i = 0; i < tagArray.length; ++i) {
                parameters.filterPreferences.add(new TagNotificationFilterPreference(tagArray[i], currentWiki));
            }
        }
    }

    private void handleSubwikiWithoutLocationParameters(NotificationParameters notificationParameters, String pages, String spaces, String wikis, String currentWiki) {
        if (StringUtils.isBlank((CharSequence)pages) && StringUtils.isBlank((CharSequence)spaces) && StringUtils.isBlank((CharSequence)wikis) && !StringUtils.equals((CharSequence)currentWiki, (CharSequence)this.wikiDescriptorManager.getMainWikiId())) {
            this.handleLocationParameter(currentWiki, notificationParameters, NotificationFilterProperty.WIKI, currentWiki);
        }
    }
}

