/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.internal.SimilarityCalculator;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.PreferenceDateNotificationFilter;
import org.xwiki.notifications.sources.internal.QueryGenerator;
import org.xwiki.notifications.sources.internal.RecordableEventDescriptorHelper;
import org.xwiki.query.Query;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultParametrizedNotificationManager
implements ParametrizedNotificationManager {
    private static final int MAX_BATCH_SIZE = 1280;
    @Inject
    private EventStream eventStream;
    @Inject
    private QueryGenerator queryGenerator;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private SimilarityCalculator similarityCalculator;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="eventReadAlertFilter")
    private NotificationFilter eventReadAlertFilter;
    @Inject
    @Named(value="eventReadEmailFilter")
    private NotificationFilter eventReadEmailFilter;
    @Inject
    private RecordableEventDescriptorHelper recordableEventDescriptorHelper;
    @Inject
    private PreferenceDateNotificationFilter preferenceDateNotificationFilter;

    @Override
    public List<CompositeEvent> getEvents(NotificationParameters parameters) throws NotificationException {
        if (Boolean.TRUE.equals(parameters.onlyUnread) && !parameters.filters.contains(this.eventReadAlertFilter)) {
            parameters.filters.add(this.eventReadAlertFilter);
        }
        if (Boolean.TRUE.equals(parameters.onlyUnread) && !parameters.filters.contains(this.eventReadEmailFilter)) {
            parameters.filters.add(this.eventReadEmailFilter);
        }
        return this.getEvents(new ArrayList<CompositeEvent>(), parameters);
    }

    private List<CompositeEvent> getEvents(List<CompositeEvent> results, NotificationParameters parameters) throws NotificationException {
        int batchSize = parameters.expectedCount * 2;
        int offset = 0;
        try {
            boolean done = false;
            while (!done) {
                Query query = this.queryGenerator.generateQuery(parameters);
                if (query == null) {
                    return Collections.emptyList();
                }
                query.setLimit(batchSize).setOffset(offset);
                List batch = this.eventStream.searchEvents(query);
                done = this.addMatchingEventsToResults(batch, parameters, results);
                if (done) continue;
                if (batch.size() < batchSize) {
                    done = true;
                    continue;
                }
                offset += batchSize;
                if (batchSize >= 1280) continue;
                batchSize <<= 1;
            }
            return results;
        }
        catch (Exception e) {
            throw new NotificationException("Fail to get the list of notifications.", (Throwable)e);
        }
    }

    private boolean addMatchingEventsToResults(List<Event> batch, NotificationParameters parameters, List<CompositeEvent> results) throws EventStreamException, NotificationException {
        boolean done = false;
        for (Event event : batch) {
            DocumentReference document = event.getDocument();
            if (document != null && !this.isAllowed(parameters.user, document) || this.filterEvent(event, parameters)) continue;
            this.recordEvent(results, event);
            if (results.size() < parameters.expectedCount) continue;
            done = true;
            break;
        }
        return done;
    }

    private boolean isAllowed(DocumentReference passedUser, DocumentReference document) {
        boolean allowed = this.authorizationManager.hasAccess(Right.VIEW, passedUser, (EntityReference)document);
        if (allowed) {
            allowed = this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)document);
        }
        return allowed;
    }

    private boolean filterEvent(Event event, NotificationParameters parameters) throws EventStreamException {
        if (!(event.getTarget().isEmpty() || parameters.user != null && event.getTarget().contains(this.serializer.serialize((EntityReference)parameters.user, new Object[0])))) {
            return true;
        }
        if (!this.recordableEventDescriptorHelper.hasDescriptor(event.getType(), parameters.user) || this.preferenceDateNotificationFilter.shouldFilter(event, parameters.preferences)) {
            return true;
        }
        ArrayList<NotificationFilter> filters = new ArrayList<NotificationFilter>(parameters.filters);
        Collections.sort(filters);
        for (NotificationFilter filter : filters) {
            NotificationFilter.FilterPolicy policy = filter.filterEvent(event, parameters.user, parameters.filterPreferences, parameters.format);
            switch (policy) {
                case FILTER: {
                    return true;
                }
                case KEEP: {
                    return false;
                }
            }
        }
        return false;
    }

    private List<String> getEventsIds(List<Event> events) {
        return events.stream().map(Event::getId).collect(Collectors.toList());
    }

    private void recordEvent(List<CompositeEvent> results, Event event) throws NotificationException {
        BestSimilarity bestSimilarity = this.getBestSimilarity(results, event);
        if (bestSimilarity.compositeEvent != null) {
            if (bestSimilarity.value > bestSimilarity.compositeEvent.getSimilarityBetweenEvents() && bestSimilarity.compositeEvent.getEvents().size() > 1) {
                bestSimilarity.compositeEvent.remove(bestSimilarity.event);
                BestSimilarity bestSecondChoice = this.getBestSimilarity(results, event);
                if (bestSecondChoice.compositeEvent != null && bestSecondChoice.isCompositeEventCompatibleWith(event)) {
                    bestSecondChoice.compositeEvent.add(bestSimilarity.event, bestSecondChoice.compositeEvent.getSimilarityBetweenEvents());
                    bestSecondChoice.compositeEvent.add(event, bestSecondChoice.compositeEvent.getSimilarityBetweenEvents());
                } else {
                    CompositeEvent newCompositeEvent = new CompositeEvent(event);
                    newCompositeEvent.add(bestSimilarity.event, bestSimilarity.value);
                    results.add(newCompositeEvent);
                }
                return;
            }
            if (bestSimilarity.value >= bestSimilarity.compositeEvent.getSimilarityBetweenEvents()) {
                bestSimilarity.compositeEvent.add(event, bestSimilarity.value);
                return;
            }
            if (bestSimilarity.isCompositeEventCompatibleWith(event)) {
                bestSimilarity.compositeEvent.add(event, bestSimilarity.compositeEvent.getSimilarityBetweenEvents());
                return;
            }
        }
        results.add(new CompositeEvent(event));
    }

    private BestSimilarity getBestSimilarity(List<CompositeEvent> results, Event event) {
        BestSimilarity bestSimilarity = new BestSimilarity();
        for (CompositeEvent existingCompositeEvent : results) {
            for (Event existingEvent : existingCompositeEvent.getEvents()) {
                int similarity = this.similarityCalculator.computeSimilarity(event, existingEvent);
                if (similarity < existingCompositeEvent.getSimilarityBetweenEvents()) {
                    similarity -= 5;
                }
                if (similarity <= bestSimilarity.value) continue;
                bestSimilarity.value = similarity;
                bestSimilarity.event = existingEvent;
                bestSimilarity.compositeEvent = existingCompositeEvent;
            }
        }
        return bestSimilarity;
    }

    private class BestSimilarity {
        public int value;
        public CompositeEvent compositeEvent;
        public Event event;

        private BestSimilarity() {
        }

        public boolean isCompositeEventCompatibleWith(Event event) {
            return this.compositeEvent.getSimilarityBetweenEvents() >= 10000 && this.compositeEvent.getType().equals(event.getType());
        }
    }
}

