/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.observation.remote.NetworkAdapter;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteEventException;
import org.xwiki.observation.remote.jgroups.JGroupsReceiver;

@Component
@Named(value="jgroups")
@Singleton
public class JGroupsNetworkAdapter
implements NetworkAdapter {
    public static final String CONFIGURATION_PATH = "observation/remote/jgroups/";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private Map<String, JChannel> channels = new ConcurrentHashMap<String, JChannel>();

    @Override
    public void send(RemoteEventData remoteEvent) {
        this.logger.debug("Send JGroups remote event [" + remoteEvent + "]");
        Message message = new Message(null, (Object)remoteEvent);
        for (Map.Entry<String, JChannel> entry : this.channels.entrySet()) {
            try {
                entry.getValue().send(message);
            }
            catch (Exception e) {
                this.logger.error("Failed to send message [" + remoteEvent + "] to the channel [" + entry.getKey() + "]", (Throwable)e);
            }
        }
    }

    @Override
    public void startChannel(String channelId) throws RemoteEventException {
        JChannel channel;
        if (this.channels.containsKey(channelId)) {
            throw new RemoteEventException(MessageFormat.format("Channel [{0}] already started", channelId));
        }
        try {
            channel = this.createChannel(channelId);
            channel.connect("event");
            this.channels.put(channelId, channel);
        }
        catch (Exception e) {
            throw new RemoteEventException("Failed to create channel [" + channelId + "]", e);
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)mbs, (String)channel.getClusterName());
        }
        catch (Exception e) {
            this.logger.warn("Failed to register channel [" + channelId + "] against the JMX Server", (Throwable)e);
        }
        this.logger.info("Channel [{}] started", (Object)channelId);
    }

    @Override
    public void stopChannel(String channelId) throws RemoteEventException {
        JChannel channel = this.channels.get(channelId);
        if (channel == null) {
            throw new RemoteEventException(MessageFormat.format("Channel [{0}] is not started", channelId));
        }
        channel.close();
        this.channels.remove(channelId);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            JmxConfigurator.unregister((Object)channel, (MBeanServer)mbs, (String)channel.getClusterName());
        }
        catch (Exception e) {
            this.logger.warn("Failed to unregister channel [" + channelId + "] from the JMX Server", (Throwable)e);
        }
        this.logger.info("Channel [{}] stopped", (Object)channelId);
    }

    private JChannel createChannel(String channelId) throws Exception {
        JGroupsReceiver channelReceiver;
        ProtocolStackConfigurator channelConf = this.loadChannelConfiguration(channelId);
        try {
            channelReceiver = (JGroupsReceiver)this.componentManager.getInstance(JGroupsReceiver.class, channelId);
        }
        catch (ComponentLookupException e) {
            channelReceiver = (JGroupsReceiver)this.componentManager.getInstance(JGroupsReceiver.class);
        }
        JChannel channel = new JChannel(channelConf);
        channel.setReceiver((Receiver)channelReceiver);
        channel.setDiscardOwnMessages(true);
        return channel;
    }

    private ProtocolStackConfigurator loadChannelConfiguration(String channelId) throws IOException {
        String channelFile = channelId + ".xml";
        String path = "/WEB-INF/observation/remote/jgroups/" + channelFile;
        InputStream is = null;
        try {
            Environment environment = (Environment)this.componentManager.getInstance(Environment.class);
            is = environment.getResourceAsStream(path);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup the Environment component.", (Throwable)e);
        }
        if (is == null && (is = ConfiguratorFactory.getConfigStream((String)channelFile)) == null && !"udp.xml".equals(channelFile)) {
            is = ConfiguratorFactory.getConfigStream((String)"udp.xml");
        }
        return XmlConfigurator.getInstance((InputStream)is);
    }

    @Override
    public void stopAllChannels() throws RemoteEventException {
        for (Map.Entry<String, JChannel> channelEntry : this.channels.entrySet()) {
            channelEntry.getValue().close();
        }
        this.channels.clear();
        this.logger.info("All channels stopped");
    }
}

