/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.office.viewer.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.office.viewer.OfficeResourceViewer;
import org.xwiki.office.viewer.internal.AttachmentOfficeDocumentView;
import org.xwiki.office.viewer.internal.OfficeDocumentView;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.reference.ResourceReferenceTypeSerializer;

@Component
@Singleton
public class DefaultOfficeResourceViewer
implements OfficeResourceViewer,
Initializable {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MODULE_NAME = "officeviewer";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Environment environment;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ResourceReferenceTypeSerializer resourceReferenceSerializer;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> attachmentResolver;
    @Inject
    private CacheManager cacheManager;
    private Cache<AttachmentOfficeDocumentView> attachmentCache;
    private Cache<OfficeDocumentView> externalCache;
    @Inject
    private XDOMOfficeDocumentBuilder documentBuilder;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private ConverterManager converter;
    @Inject
    private Logger logger;

    String getFilePath(String resourceName, String fileName, Map<String, ?> parameters) {
        try {
            return URLEncoder.encode(this.getSafeFileName(resourceName), DEFAULT_ENCODING) + '/' + parameters.hashCode() + '/' + URLEncoder.encode(this.getSafeFileName(fileName), DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Cannot use UTF8 encoding", (Throwable)e);
            return resourceName + '/' + fileName;
        }
    }

    private Set<File> processImages(XDOM xdom, Map<String, byte[]> artifacts, DocumentReference documentReference, String resourceReference, Map<String, ?> parameters) {
        HashSet<File> temporaryFiles = new HashSet<File>();
        List imgBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(ImageBlock.class), Block.Axes.DESCENDANT);
        for (ImageBlock imgBlock : imgBlocks) {
            String imageReference = imgBlock.getReference().getReference();
            if (!artifacts.containsKey(imageReference)) continue;
            try {
                String filePath = this.getFilePath(resourceReference, imageReference, parameters);
                File tempFile = this.getTemporaryFile(documentReference, filePath);
                this.createTemporaryFile(tempFile, artifacts.get(imageReference));
                ResourceReference urlImageReference = new ResourceReference(this.buildURL(documentReference, filePath), ResourceType.URL);
                urlImageReference.setTyped(false);
                ImageBlock newImgBlock = new ImageBlock(urlImageReference, false, imgBlock.getParameters());
                imgBlock.getParent().replaceChild(Arrays.asList(newImgBlock), (Block)imgBlock);
                temporaryFiles.add(tempFile);
            }
            catch (Exception ex) {
                String message = "Error while processing artifact image [%s].";
                this.logger.error(String.format(message, imageReference), (Throwable)ex);
            }
        }
        return temporaryFiles;
    }

    private XDOMOfficeDocument createXDOM(AttachmentReference attachmentReference, Map<String, ?> parameters) throws Exception {
        InputStream officeFileStream = this.documentAccessBridge.getAttachmentContent(attachmentReference);
        String officeFileName = attachmentReference.getName();
        return this.createXDOM(attachmentReference.getDocumentReference(), officeFileStream, officeFileName, parameters);
    }

    private XDOMOfficeDocument createXDOM(DocumentReference ownerDocument, ResourceReference resourceReference, Map<String, ?> parameters) throws Exception {
        if (!resourceReference.getType().equals((Object)ResourceType.URL)) {
            throw new Exception(String.format("Unsupported resource type [%s].", resourceReference.getType()));
        }
        URL url = new URL(resourceReference.getReference());
        InputStream officeFileStream = url.openStream();
        String officeFileName = StringUtils.substringAfterLast((String)url.getPath(), (String)"/");
        return this.createXDOM(ownerDocument, officeFileStream, officeFileName, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XDOMOfficeDocument createXDOM(DocumentReference ownerDocument, InputStream officeFileStream, String officeFileName, Map<String, ?> parameters) throws Exception {
        try {
            if (this.isPresentation(officeFileName)) {
                XDOMOfficeDocument xDOMOfficeDocument = this.presentationBuilder.build(officeFileStream, officeFileName, ownerDocument);
                return xDOMOfficeDocument;
            }
            boolean filterStyles = (Boolean)this.converter.convert(Boolean.TYPE, parameters.get("filterStyles"));
            XDOMOfficeDocument xDOMOfficeDocument = this.documentBuilder.build(officeFileStream, officeFileName, ownerDocument, filterStyles);
            return xDOMOfficeDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)officeFileStream);
        }
    }

    private boolean isPresentation(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        OfficeConverter officeConverter = this.officeServer.getConverter();
        if (officeConverter != null) {
            DocumentFormat format = officeConverter.getFormatRegistry().getFormatByExtension(extension);
            return format != null && format.getInputFamily() == DocumentFamily.PRESENTATION;
        }
        return false;
    }

    public void initialize() throws InitializationException {
        try {
            LRUCacheConfiguration attachmentConfig = new LRUCacheConfiguration("officeviewer.attachment", 50);
            this.attachmentCache = this.cacheManager.createNewCache((CacheConfiguration)attachmentConfig);
            LRUCacheConfiguration exteralConfig = new LRUCacheConfiguration("officeviewer.external", 50, 3600);
            this.externalCache = this.cacheManager.createNewCache((CacheConfiguration)exteralConfig);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create caches.", (Throwable)e);
        }
    }

    private OfficeDocumentView getView(ResourceReference reference, AttachmentReference attachmentReference, Map<String, ?> parameters) throws Exception {
        String cacheKey = this.getCacheKey(attachmentReference.getDocumentReference(), attachmentReference.getName(), parameters);
        AttachmentOfficeDocumentView view = (AttachmentOfficeDocumentView)this.attachmentCache.get(cacheKey);
        DocumentReference documentReference = attachmentReference.getDocumentReference();
        if (!this.documentAccessBridge.getAttachmentReferences(documentReference).contains(attachmentReference)) {
            if (view != null) {
                this.attachmentCache.remove(cacheKey);
            }
            throw new Exception(String.format("Attachment [%s] does not exist.", attachmentReference));
        }
        String currentVersion = this.documentAccessBridge.getAttachmentVersion(attachmentReference);
        if (view != null && !currentVersion.equals(view.getVersion())) {
            this.attachmentCache.remove(cacheKey);
            view = null;
        }
        if (view == null) {
            XDOMOfficeDocument xdomOfficeDocument = this.createXDOM(attachmentReference, parameters);
            String attachmentVersion = this.documentAccessBridge.getAttachmentVersion(attachmentReference);
            XDOM xdom = xdomOfficeDocument.getContentDocument();
            Set<File> temporaryFiles = this.processImages(xdom, xdomOfficeDocument.getArtifacts(), attachmentReference.getDocumentReference(), this.resourceReferenceSerializer.serialize(reference), parameters);
            view = new AttachmentOfficeDocumentView(reference, attachmentReference, attachmentVersion, xdom, temporaryFiles);
            this.attachmentCache.set(cacheKey, (Object)view);
        }
        return view;
    }

    private OfficeDocumentView getView(ResourceReference resourceReference, Map<String, ?> parameters) throws Exception {
        String serializedResourceReference;
        DocumentReference ownerDocument = this.getOwnerDocument(parameters);
        String cacheKey = this.getCacheKey(ownerDocument, serializedResourceReference = this.resourceReferenceSerializer.serialize(resourceReference), parameters);
        OfficeDocumentView view = (OfficeDocumentView)this.externalCache.get(cacheKey);
        if (view == null) {
            XDOMOfficeDocument xdomOfficeDocument = this.createXDOM(ownerDocument, resourceReference, parameters);
            XDOM xdom = xdomOfficeDocument.getContentDocument();
            Set<File> temporaryFiles = this.processImages(xdom, xdomOfficeDocument.getArtifacts(), ownerDocument, serializedResourceReference, parameters);
            view = new OfficeDocumentView(resourceReference, xdom, temporaryFiles);
            this.externalCache.set(cacheKey, (Object)view);
        }
        return view;
    }

    @Override
    public XDOM createView(ResourceReference reference, Map<String, ?> parameters) throws Exception {
        OfficeDocumentView view;
        if (reference.getType().equals((Object)ResourceType.ATTACHMENT) || reference.getType().equals((Object)ResourceType.UNKNOWN)) {
            AttachmentReference attachmentReference = this.attachmentResolver.resolve((Object)reference.getReference(), new Object[0]);
            view = this.getView(reference, attachmentReference, parameters);
        } else {
            view = this.getView(reference, parameters);
        }
        return view.getXDOM().clone();
    }

    private String getCacheKey(DocumentReference ownerDocument, String resource, Map<String, ?> parameters) {
        return (String)this.serializer.serialize((EntityReference)ownerDocument, new Object[0]) + '/' + resource + '/' + parameters.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemporaryFile(File file, byte[] fileData) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            file.deleteOnExit();
            IOUtils.write((byte[])fileData, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    File getTemporaryFile(DocumentReference documentReference, String filepath) throws Exception {
        boolean success;
        String wiki = documentReference.getWikiReference().getName();
        String space = documentReference.getParent().getName();
        String page = documentReference.getName();
        wiki = this.getSafeFileName(wiki);
        space = this.getSafeFileName(space);
        page = this.getSafeFileName(page);
        String path = String.format("temp/%s/%s/%s/%s/", MODULE_NAME, wiki, space, page);
        File rootDir = this.environment.getTemporaryDirectory();
        File tempDir = new File(rootDir, path);
        File tempFile = new File(tempDir, filepath);
        File parentFolder = tempFile.getParentFile();
        boolean bl = success = (parentFolder.exists() || parentFolder.mkdirs()) && parentFolder.isDirectory() && parentFolder.canWrite();
        if (!success) {
            String message = "Error while creating temporary directory [%s].";
            throw new Exception(String.format(message, tempDir));
        }
        return tempFile;
    }

    private String buildURL(DocumentReference ownerDocument, String filePath) {
        String prefix = this.documentAccessBridge.getDocumentURL(ownerDocument, "temp", null, null, true);
        return String.format("%s/%s/%s", prefix, MODULE_NAME, filePath);
    }

    private String getSafeFileName(String name) {
        String encoded;
        try {
            encoded = URLEncoder.encode(name, DEFAULT_ENCODING).replace(".", "%2E").replace("*", "%2A");
            encoded = encoded.replace("%2E", ".");
            encoded = encoded.replace("+", " ");
        }
        catch (UnsupportedEncodingException e) {
            encoded = name;
        }
        return encoded;
    }

    private DocumentReference getOwnerDocument(Map<String, ?> parameters) {
        DocumentReference ownerDocument = (DocumentReference)this.converter.convert(DocumentReference.class, parameters.get("ownerDocument"));
        if (ownerDocument == null) {
            this.documentAccessBridge.getCurrentDocumentReference();
        }
        return ownerDocument;
    }
}

