/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.panels.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionManager;

public abstract class AbstractPanelsUIExtensionManager
implements UIExtensionManager {
    @Inject
    protected ConfigurationSource configurationSource;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private AsyncContext asyncContext;

    protected abstract String getConfiguration();

    public List<UIExtension> get(String extensionPointId) {
        ArrayList<UIExtension> panels = new ArrayList<UIExtension>();
        String panelConfigurationString = this.getConfiguration();
        if (!StringUtils.isEmpty((CharSequence)panelConfigurationString)) {
            HashMap<DocumentReference, Integer> panelReferenceWithPosition = new HashMap<DocumentReference, Integer>();
            String[] panelStringReferences = panelConfigurationString.split(",");
            for (int i = 0; i < panelStringReferences.length; ++i) {
                panelReferenceWithPosition.put(this.resolver.resolve((Object)panelStringReferences[i].trim(), new Object[0]), i);
            }
            try {
                List allExtensions = ((ComponentManager)this.contextComponentManagerProvider.get()).getInstanceList(UIExtension.class);
                HashMap panelsPositions = new HashMap();
                for (UIExtension extension : allExtensions) {
                    DocumentReference extensionId;
                    if (extension instanceof WikiComponent) {
                        WikiComponent wikiComponent = (WikiComponent)extension;
                        extensionId = wikiComponent.getDocumentReference();
                    } else {
                        extensionId = this.resolver.resolve((Object)extension.getId(), new Object[0]);
                    }
                    if (!panelReferenceWithPosition.containsKey(extensionId)) continue;
                    panelsPositions.put(extension, panelReferenceWithPosition.get(extensionId));
                }
                panels.addAll(panelsPositions.keySet());
                panels.sort(Comparator.comparing(panelsPositions::get));
                this.asyncContext.useComponent(UIExtension.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup Panels instances, error: [{}]", (Throwable)e);
            }
        }
        return panels;
    }
}

