/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.panels.internal;

import com.xpn.xwiki.XWikiContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.panels.internal.PanelWikiUIExtension;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
@Named(value="panels")
public class PanelWikiUIExtensionComponentBuilder
implements WikiComponentBuilder {
    @Inject
    private Execution execution;
    @Inject
    private QueryManager queryManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public List<DocumentReference> getDocumentReferences() {
        ArrayList<DocumentReference> references = new ArrayList<DocumentReference>();
        try {
            Query query = this.queryManager.createQuery("select doc.space, doc.name from Document doc, doc.object(Panels.PanelClass) as panel", "xwql");
            List results = query.execute();
            for (Object[] result : results) {
                references.add(new DocumentReference(this.getXWikiContext().getDatabase(), (String)result[0], (String)result[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return references;
    }

    public List<WikiComponent> buildComponents(DocumentReference reference) throws WikiComponentException {
        ArrayList<WikiComponent> components = new ArrayList<WikiComponent>();
        DocumentReference panelXClass = new DocumentReference(this.getXWikiContext().getDatabase(), "Panels", "PanelClass");
        String content = (String)this.documentAccessBridge.getProperty(reference, panelXClass, "content");
        Syntax syntax = null;
        try {
            syntax = this.documentAccessBridge.getDocument(reference).getSyntax();
            DocumentReference authorReference = this.getXWikiContext().getWiki().getDocument(reference, this.getXWikiContext()).getAuthorReference();
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntax.toIdString());
            try {
                XDOM xdom = parser.parse((Reader)new StringReader(content));
                components.add(new PanelWikiUIExtension(reference, authorReference, xdom, syntax, this.componentManager));
            }
            catch (ParseException e) {
                throw new WikiComponentException(String.format("Failed to find parse content of panel [{}]", reference));
            }
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to find a parser for syntax [{}]", syntax));
        }
        catch (Exception e) {
            String.format("Failed to retrieve panel document [{}]", reference);
        }
        return components;
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

