/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal.jpql.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.xwiki.query.internal.jpql.lexer.LexerException;
import org.xwiki.query.internal.jpql.node.EOF;
import org.xwiki.query.internal.jpql.node.TAbs;
import org.xwiki.query.internal.jpql.node.TAddSub;
import org.xwiki.query.internal.jpql.node.TAggregateFunc;
import org.xwiki.query.internal.jpql.node.TAllAnySome;
import org.xwiki.query.internal.jpql.node.TAnd;
import org.xwiki.query.internal.jpql.node.TAs;
import org.xwiki.query.internal.jpql.node.TBetween;
import org.xwiki.query.internal.jpql.node.TBooleanLiteral;
import org.xwiki.query.internal.jpql.node.TBy;
import org.xwiki.query.internal.jpql.node.TComma;
import org.xwiki.query.internal.jpql.node.TComparisonOperator;
import org.xwiki.query.internal.jpql.node.TConcat;
import org.xwiki.query.internal.jpql.node.TCount;
import org.xwiki.query.internal.jpql.node.TDistinct;
import org.xwiki.query.internal.jpql.node.TDot;
import org.xwiki.query.internal.jpql.node.TEmpty;
import org.xwiki.query.internal.jpql.node.TEscape;
import org.xwiki.query.internal.jpql.node.TExists;
import org.xwiki.query.internal.jpql.node.TFetch;
import org.xwiki.query.internal.jpql.node.TFloatLiteral;
import org.xwiki.query.internal.jpql.node.TFrom;
import org.xwiki.query.internal.jpql.node.TFunctionsReturningDatetime;
import org.xwiki.query.internal.jpql.node.TGroup;
import org.xwiki.query.internal.jpql.node.THaving;
import org.xwiki.query.internal.jpql.node.TId;
import org.xwiki.query.internal.jpql.node.TIn;
import org.xwiki.query.internal.jpql.node.TInner;
import org.xwiki.query.internal.jpql.node.TInputParameter;
import org.xwiki.query.internal.jpql.node.TIntegerLiteral;
import org.xwiki.query.internal.jpql.node.TIs;
import org.xwiki.query.internal.jpql.node.TLbr;
import org.xwiki.query.internal.jpql.node.TLeft;
import org.xwiki.query.internal.jpql.node.TLength;
import org.xwiki.query.internal.jpql.node.TLike;
import org.xwiki.query.internal.jpql.node.TLocate;
import org.xwiki.query.internal.jpql.node.TLower;
import org.xwiki.query.internal.jpql.node.TMember;
import org.xwiki.query.internal.jpql.node.TMod;
import org.xwiki.query.internal.jpql.node.TMulDiv;
import org.xwiki.query.internal.jpql.node.TNot;
import org.xwiki.query.internal.jpql.node.TNull;
import org.xwiki.query.internal.jpql.node.TObject;
import org.xwiki.query.internal.jpql.node.TOf;
import org.xwiki.query.internal.jpql.node.TOr;
import org.xwiki.query.internal.jpql.node.TOrder;
import org.xwiki.query.internal.jpql.node.TOrderbySpec;
import org.xwiki.query.internal.jpql.node.TOuter;
import org.xwiki.query.internal.jpql.node.TRbr;
import org.xwiki.query.internal.jpql.node.TSelect;
import org.xwiki.query.internal.jpql.node.TSize;
import org.xwiki.query.internal.jpql.node.TSqrt;
import org.xwiki.query.internal.jpql.node.TStringLiteral;
import org.xwiki.query.internal.jpql.node.TSubstring;
import org.xwiki.query.internal.jpql.node.TTJoin;
import org.xwiki.query.internal.jpql.node.TTrim;
import org.xwiki.query.internal.jpql.node.TTrimSpecification;
import org.xwiki.query.internal.jpql.node.TUpper;
import org.xwiki.query.internal.jpql.node.TWhere;
import org.xwiki.query.internal.jpql.node.TWhite;
import org.xwiki.query.internal.jpql.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block66: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block66;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 18: {
                    Token token = this.new18(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 19: {
                    Token token = this.new19(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 20: {
                    Token token = this.new20(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 21: {
                    Token token = this.new21(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 22: {
                    Token token = this.new22(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 23: {
                    Token token = this.new23(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 24: {
                    Token token = this.new24(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 26: {
                    Token token = this.new26(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 27: {
                    Token token = this.new27(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 28: {
                    Token token = this.new28(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 29: {
                    Token token = this.new29(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 30: {
                    Token token = this.new30(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 31: {
                    Token token = this.new31(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 32: {
                    Token token = this.new32(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 35: {
                    Token token = this.new35(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 36: {
                    Token token = this.new36(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 37: {
                    Token token = this.new37(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 38: {
                    Token token = this.new38(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 39: {
                    Token token = this.new39(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 40: {
                    Token token = this.new40(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 41: {
                    Token token = this.new41(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 42: {
                    Token token = this.new42(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 43: {
                    Token token = this.new43(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 44: {
                    Token token = this.new44(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 45: {
                    Token token = this.new45(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 46: {
                    Token token = this.new46(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 47: {
                    Token token = this.new47(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 48: {
                    Token token = this.new48(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 49: {
                    Token token = this.new49(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 50: {
                    Token token = this.new50(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 51: {
                    Token token = this.new51(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 52: {
                    Token token = this.new52(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 53: {
                    Token token = this.new53(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 54: {
                    Token token = this.new54(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 55: {
                    Token token = this.new55(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 56: {
                    Token token = this.new56(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 57: {
                    Token token = this.new57(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 58: {
                    Token token = this.new58(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "] Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TWhite(text, line, pos);
    }

    Token new1(int line, int pos) {
        return new TComma(line, pos);
    }

    Token new2(int line, int pos) {
        return new TLbr(line, pos);
    }

    Token new3(int line, int pos) {
        return new TRbr(line, pos);
    }

    Token new4(int line, int pos) {
        return new TDot(line, pos);
    }

    Token new5(String text, int line, int pos) {
        return new TAbs(text, line, pos);
    }

    Token new6(String text, int line, int pos) {
        return new TAnd(text, line, pos);
    }

    Token new7(String text, int line, int pos) {
        return new TAs(text, line, pos);
    }

    Token new8(String text, int line, int pos) {
        return new TBetween(text, line, pos);
    }

    Token new9(String text, int line, int pos) {
        return new TBy(text, line, pos);
    }

    Token new10(String text, int line, int pos) {
        return new TConcat(text, line, pos);
    }

    Token new11(String text, int line, int pos) {
        return new TCount(text, line, pos);
    }

    Token new12(String text, int line, int pos) {
        return new TDistinct(text, line, pos);
    }

    Token new13(String text, int line, int pos) {
        return new TEmpty(text, line, pos);
    }

    Token new14(String text, int line, int pos) {
        return new TEscape(text, line, pos);
    }

    Token new15(String text, int line, int pos) {
        return new TExists(text, line, pos);
    }

    Token new16(String text, int line, int pos) {
        return new TFetch(text, line, pos);
    }

    Token new17(String text, int line, int pos) {
        return new TFrom(text, line, pos);
    }

    Token new18(String text, int line, int pos) {
        return new TGroup(text, line, pos);
    }

    Token new19(String text, int line, int pos) {
        return new THaving(text, line, pos);
    }

    Token new20(String text, int line, int pos) {
        return new TIn(text, line, pos);
    }

    Token new21(String text, int line, int pos) {
        return new TInner(text, line, pos);
    }

    Token new22(String text, int line, int pos) {
        return new TIs(text, line, pos);
    }

    Token new23(String text, int line, int pos) {
        return new TTJoin(text, line, pos);
    }

    Token new24(String text, int line, int pos) {
        return new TLeft(text, line, pos);
    }

    Token new25(String text, int line, int pos) {
        return new TLength(text, line, pos);
    }

    Token new26(String text, int line, int pos) {
        return new TLike(text, line, pos);
    }

    Token new27(String text, int line, int pos) {
        return new TLocate(text, line, pos);
    }

    Token new28(String text, int line, int pos) {
        return new TLower(text, line, pos);
    }

    Token new29(String text, int line, int pos) {
        return new TMember(text, line, pos);
    }

    Token new30(String text, int line, int pos) {
        return new TMod(text, line, pos);
    }

    Token new31(String text, int line, int pos) {
        return new TNot(text, line, pos);
    }

    Token new32(String text, int line, int pos) {
        return new TNull(text, line, pos);
    }

    Token new33(String text, int line, int pos) {
        return new TOf(text, line, pos);
    }

    Token new34(String text, int line, int pos) {
        return new TOr(text, line, pos);
    }

    Token new35(String text, int line, int pos) {
        return new TObject(text, line, pos);
    }

    Token new36(String text, int line, int pos) {
        return new TOrder(text, line, pos);
    }

    Token new37(String text, int line, int pos) {
        return new TOuter(text, line, pos);
    }

    Token new38(String text, int line, int pos) {
        return new TSelect(text, line, pos);
    }

    Token new39(String text, int line, int pos) {
        return new TSize(text, line, pos);
    }

    Token new40(String text, int line, int pos) {
        return new TSqrt(text, line, pos);
    }

    Token new41(String text, int line, int pos) {
        return new TSubstring(text, line, pos);
    }

    Token new42(String text, int line, int pos) {
        return new TTrim(text, line, pos);
    }

    Token new43(String text, int line, int pos) {
        return new TUpper(text, line, pos);
    }

    Token new44(String text, int line, int pos) {
        return new TWhere(text, line, pos);
    }

    Token new45(String text, int line, int pos) {
        return new TBooleanLiteral(text, line, pos);
    }

    Token new46(String text, int line, int pos) {
        return new TIntegerLiteral(text, line, pos);
    }

    Token new47(String text, int line, int pos) {
        return new TFloatLiteral(text, line, pos);
    }

    Token new48(String text, int line, int pos) {
        return new TStringLiteral(text, line, pos);
    }

    Token new49(String text, int line, int pos) {
        return new TInputParameter(text, line, pos);
    }

    Token new50(String text, int line, int pos) {
        return new TAggregateFunc(text, line, pos);
    }

    Token new51(String text, int line, int pos) {
        return new TOrderbySpec(text, line, pos);
    }

    Token new52(String text, int line, int pos) {
        return new TAllAnySome(text, line, pos);
    }

    Token new53(String text, int line, int pos) {
        return new TComparisonOperator(text, line, pos);
    }

    Token new54(String text, int line, int pos) {
        return new TAddSub(text, line, pos);
    }

    Token new55(String text, int line, int pos) {
        return new TMulDiv(text, line, pos);
    }

    Token new56(String text, int line, int pos) {
        return new TFunctionsReturningDatetime(text, line, pos);
    }

    Token new57(String text, int line, int pos) {
        return new TTrimSpecification(text, line, pos);
    }

    Token new58(String text, int line, int pos) {
        return new TId(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(text.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        for (int i = 0; i < acceptLength; ++i) {
            s.append(this.text.charAt(i));
        }
        return s.toString();
    }

    static {
        try {
            int j;
            int i;
            DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for (i = 0; i < gotoTable.length; ++i) {
                length = s.readInt();
                Lexer.gotoTable[i] = new int[length][][];
                for (j = 0; j < gotoTable[i].length; ++j) {
                    length = s.readInt();
                    Lexer.gotoTable[i][j] = new int[length][3];
                    for (int k = 0; k < gotoTable[i][j].length; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }
            length = s.readInt();
            accept = new int[length][];
            for (i = 0; i < accept.length; ++i) {
                length = s.readInt();
                Lexer.accept[i] = new int[length];
                for (j = 0; j < accept[i].length; ++j) {
                    Lexer.accept[i][j] = s.readInt();
                }
            }
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

