/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.internal.AbstractWhereQueryFilter;

@Component
@Named(value="text")
@Singleton
public class TextQueryFilter
extends AbstractWhereQueryFilter {
    private static final Pattern SELECT = Pattern.compile("^\\s*select\\s+", 2);
    private static final Pattern DISTINCT = Pattern.compile("^distinct\\s+", 2);
    private static final Pattern AS = Pattern.compile("\\s+as\\s+", 2);
    private static final Pattern FROM = Pattern.compile("\\s+from\\s+", 2);
    private static final Pattern COLUMN_SEPARATOR = Pattern.compile("\\s*,\\s*");

    @Override
    public String filterStatement(String statement, String language) {
        String constraint = this.getFilterableColumns(statement).stream().map(column -> "lower(str(" + column + ")) like lower(:text)").collect(Collectors.joining(" or "));
        if (constraint.isEmpty()) {
            return statement;
        }
        return this.insertWhereClause('(' + constraint + ')', statement, language);
    }

    @Override
    public List filterResults(List results) {
        return results;
    }

    @Override
    protected boolean isFilterable(String statement) {
        return true;
    }

    private List<String> getFilterableColumns(String statement) {
        Matcher selectMatcher = SELECT.matcher(statement);
        Matcher fromMatcher = FROM.matcher(statement);
        if (!selectMatcher.lookingAt() || !fromMatcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> columns = new ArrayList<String>();
        String selectClause = statement.substring(selectMatcher.end(), fromMatcher.start());
        selectClause = DISTINCT.matcher(selectClause).replaceFirst("");
        String[] stringArray = COLUMN_SEPARATOR.split(selectClause);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String column;
            String columnWithoutAlias = column = stringArray[i];
            Matcher asMatcher = AS.matcher(column);
            if (asMatcher.find()) {
                columnWithoutAlias = column.substring(0, asMatcher.start());
                String alias = column.substring(asMatcher.end());
                if (alias.startsWith("unfilterable")) continue;
            }
            columns.add(columnWithoutAlias);
        }
        return columns;
    }
}

