/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryExecutorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(roles={QueryExecutorManager.class})
public class DefaultQueryExecutorManager
implements QueryExecutorManager {
    @Requirement
    private Map<String, QueryExecutor> executors;
    @Requirement(value="hql")
    private QueryExecutor namedQueryExecutor;

    @Override
    public <T> List<T> execute(Query query) throws QueryException {
        if (query.isNamed()) {
            return this.namedQueryExecutor.execute(query);
        }
        return this.executors.get(query.getLanguage()).execute(query);
    }

    @Override
    public Set<String> getLanguages() {
        return Collections.unmodifiableSet(this.executors.keySet());
    }
}

