/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="hidden")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class HiddenDocumentFilter
implements QueryFilter,
Initializable {
    @Inject
    @Named(value="user")
    private ConfigurationSource userPreferencesSource;
    @Inject
    private Logger logger;
    private boolean isActive;

    public void initialize() {
        Integer preference = (Integer)this.userPreferencesSource.getProperty("displayHiddenDocuments", Integer.class);
        this.isActive = preference == null || preference != 1;
    }

    private boolean isFilterable(String statement) {
        return statement.indexOf("xwikidocument as doc") > -1 || statement.indexOf("xwikidocument doc") > -1;
    }

    @Override
    public String filterStatement(String statement, String language) {
        String result = statement.trim();
        String lowerStatement = result.toLowerCase();
        String original = result;
        String where = " where ";
        if ("hql".equals(language) && this.isActive && this.isFilterable(lowerStatement)) {
            int whereIdx = lowerStatement.indexOf(where);
            int orderByIdx = Math.min(lowerStatement.indexOf(" order by "), Integer.MAX_VALUE);
            int groupByIdx = Math.min(lowerStatement.indexOf(" group by "), Integer.MAX_VALUE);
            orderByIdx = orderByIdx < 0 ? Integer.MAX_VALUE : orderByIdx;
            groupByIdx = groupByIdx < 0 ? Integer.MAX_VALUE : groupByIdx;
            int orderOrGroupByIdx = Math.min(orderByIdx, groupByIdx);
            if (whereIdx >= 0) {
                int whereEndIdx = Math.min(orderOrGroupByIdx, lowerStatement.length());
                result = result.substring(0, whereEndIdx) + ")" + result.substring(whereEndIdx);
                result = result.substring(0, whereIdx += where.length()) + "(doc.hidden <> true or doc.hidden is null) and (" + result.substring(whereIdx);
            } else {
                result = orderOrGroupByIdx > 0 && orderOrGroupByIdx < Integer.MAX_VALUE ? result.substring(0, orderOrGroupByIdx) + " where doc.hidden <> true or doc.hidden is null" + result.substring(orderOrGroupByIdx) : result + " where (doc.hidden <> true or doc.hidden is null)";
            }
        }
        if (!original.equals(result)) {
            this.logger.debug("Query [{}] has been transformed into [{}]", (Object)original, (Object)result);
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        return results;
    }
}

