/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.query.internal.AbstractQueryFilter;

@Component
@Named(value="unique")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class UniqueDocumentFilter
extends AbstractQueryFilter {
    @Inject
    private Logger logger;
    private List<Integer> columnsToRemove = new ArrayList<Integer>();

    private boolean isFilterable(String statement) {
        return this.getSelectColumns(statement).contains("doc.fullName") && !this.getSelectColumns(statement).contains("distinct doc.fullName");
    }

    @Override
    public String filterStatement(String statement, String language) {
        StringBuilder builder = new StringBuilder();
        String result = statement;
        String original = statement;
        if ("hql".equals(language) && this.isFilterable(statement)) {
            String prettySeparator = ", ";
            builder.append("select distinct doc.fullName");
            int columnPosition = 1;
            List<String> selectColumns = this.getSelectColumns(statement);
            for (String column : selectColumns) {
                if ("doc.fullName".equals(column)) continue;
                builder.append(prettySeparator);
                builder.append(column);
                ++columnPosition;
            }
            for (String column : this.getOrderByColumns(statement)) {
                if ("doc.fullName".equals(column) || selectColumns.contains(column)) continue;
                builder.append(prettySeparator);
                builder.append(column);
                this.columnsToRemove.add(columnPosition);
                ++columnPosition;
            }
            builder.append(" ");
            builder.append(statement.substring(statement.indexOf(" from ")).trim());
            result = builder.toString();
        }
        if (!statement.equals(result)) {
            this.logger.debug("Query [{}] has been transformed into [{}]", (Object)original, (Object)result);
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        if (results.size() > 0 && results.get(0).getClass().isArray()) {
            ArrayList<Object[]> filteredResults = new ArrayList<Object[]>();
            for (Object result : results) {
                Object[] actualResult = (Object[])result;
                Object[] newResult = new Object[actualResult.length - this.columnsToRemove.size()];
                int j = 0;
                for (int i = 0; i < actualResult.length; ++i) {
                    if (this.columnsToRemove.contains(i)) continue;
                    newResult[j++] = actualResult[i];
                }
                filteredResults.add((Object[])(newResult.length == 1 ? newResult[0] : newResult));
            }
            return filteredResults;
        }
        return results;
    }
}

