/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.query.internal.AbstractWhereQueryFilter;

@Component
@Named(value="hidden")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class HiddenDocumentFilter
extends AbstractWhereQueryFilter
implements Initializable {
    public static final String HINT = "hidden";
    @Inject
    @Named(value="user")
    private ConfigurationSource userPreferencesSource;
    private boolean isActive;

    public void initialize() {
        Integer preference = (Integer)this.userPreferencesSource.getProperty("displayHiddenDocuments", Integer.class);
        this.isActive = preference == null || preference != 1;
    }

    @Override
    public String filterStatement(String statement, String language) {
        String result = statement;
        if (this.isActive) {
            result = this.insertWhereClause("(doc.hidden <> true or doc.hidden is null)", statement, language);
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        return results;
    }
}

