/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.Set;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutorManager;
import org.xwiki.query.QueryManager;
import org.xwiki.query.internal.DefaultQuery;

public abstract class AbstractQueryManager
implements QueryManager {
    protected abstract QueryExecutorManager getQueryExecutorManager();

    @Override
    public Set<String> getLanguages() {
        return this.getQueryExecutorManager().getLanguages();
    }

    @Override
    public boolean hasLanguage(String language) {
        return this.getLanguages().contains(language);
    }

    @Override
    public Query createQuery(String statement, String language) throws QueryException {
        if (this.hasLanguage(language)) {
            return new DefaultQuery(statement, language, this.getQueryExecutorManager());
        }
        throw new QueryException("Language [" + language + "] is not supported", null, null);
    }

    @Override
    public Query getNamedQuery(String queryName) throws QueryException {
        return new DefaultQuery(queryName, this.getQueryExecutorManager());
    }
}

