/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.SecureQuery;

public class DefaultQuery
implements SecureQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQuery.class);
    protected boolean isNamed;
    private String statement;
    private String language;
    private String wiki;
    private Map<String, Object> namedParameters = new HashMap<String, Object>();
    private Map<Integer, Object> positionalParameters = new HashMap<Integer, Object>();
    private int limit;
    private int offset;
    private boolean checkCurrentAuthor;
    private boolean checkCurrentUser;
    private List<QueryFilter> filters = new ArrayList<QueryFilter>();
    private transient QueryExecutor executer;

    public DefaultQuery(String statement, String language, QueryExecutor executor) {
        this.statement = statement;
        this.language = language;
        this.executer = executor;
        this.isNamed = false;
    }

    public DefaultQuery(String queryName, QueryExecutor executor) {
        this.statement = queryName;
        this.executer = executor;
        this.isNamed = true;
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean isNamed() {
        return this.isNamed;
    }

    @Override
    public Query setWiki(String wiki) {
        this.wiki = wiki;
        return this;
    }

    @Override
    public String getWiki() {
        return this.wiki;
    }

    @Override
    public Query bindValue(String var, Object val) {
        this.namedParameters.put(var, val);
        return this;
    }

    @Override
    public Query bindValue(int index, Object val) {
        this.positionalParameters.put(index, val);
        return this;
    }

    @Override
    public Query bindValues(List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            if ("hql".equals(this.getLanguage())) {
                this.bindValue(i, values.get(i));
                continue;
            }
            this.bindValue(i + 1, values.get(i));
        }
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Query setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Query setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public boolean isCurrentAuthorChecked() {
        return this.checkCurrentAuthor;
    }

    @Override
    public SecureQuery checkCurrentAuthor(boolean checkCurrentAuthor) {
        this.checkCurrentAuthor = checkCurrentAuthor;
        return this;
    }

    @Override
    public boolean isCurrentUserChecked() {
        return this.checkCurrentUser;
    }

    @Override
    public SecureQuery checkCurrentUser(boolean checkUser) {
        this.checkCurrentUser = checkUser;
        return this;
    }

    @Override
    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    @Override
    public Map<Integer, Object> getPositionalParameters() {
        return this.positionalParameters;
    }

    @Override
    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    @Override
    public Query addFilter(QueryFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        } else {
            LOGGER.warn("QueryFilter [{}] already added to the query [{}]", (Object)filter.toString(), (Object)this.getStatement());
        }
        return this;
    }

    @Override
    public <T> List<T> execute() throws QueryException {
        return this.getExecuter().execute(this);
    }

    protected QueryExecutor getExecuter() {
        return this.executer;
    }

    public String toString() {
        return this.getStatement();
    }
}

