/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.internal.AbstractWhereQueryFilter;
import org.xwiki.stability.Unstable;

@Component
@Named(value="attachment")
@Singleton
@Unstable
public class AttachmentQueryFilter
extends AbstractWhereQueryFilter {
    private static final String FROM_DOC_TABLE = " XWikiDocument doc";
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public String filterStatement(String statement, String language) {
        int selectEnd;
        if ("hql".equals(language) && (selectEnd = statement.indexOf(" from ")) > 0) {
            StringBuilder filteredStatement = new StringBuilder(statement);
            filteredStatement.insert(selectEnd, ", attachment.filename");
            int fromDocTable = filteredStatement.indexOf(FROM_DOC_TABLE);
            if (fromDocTable > 0) {
                filteredStatement.insert(fromDocTable + FROM_DOC_TABLE.length(), ", XWikiAttachment attachment");
                return this.insertWhereClause("doc.id = attachment.docId", filteredStatement.toString(), language);
            }
        }
        return statement;
    }

    @Override
    public List filterResults(List results) {
        if (results.size() > 0 && results.get(0).getClass().isArray()) {
            ArrayList<AttachmentReference> attachmentReferences = new ArrayList<AttachmentReference>();
            for (Object result : results) {
                Object[] actualResult = (Object[])result;
                String documentFullName = String.valueOf(actualResult[0]);
                String attachmentFileName = String.valueOf(actualResult[1]);
                DocumentReference documentReference = this.documentReferenceResolver.resolve((Object)documentFullName, new Object[0]);
                attachmentReferences.add(new AttachmentReference(attachmentFileName, documentReference));
            }
            return attachmentReferences;
        }
        return results;
    }
}

