/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryFilter;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="viewable")
@Singleton
@Unstable
public class ViewableQueryFilter
implements QueryFilter {
    @Inject
    private ContextualAuthorizationManager authorization;

    @Override
    public String filterStatement(String statement, String language) {
        return statement;
    }

    @Override
    public List filterResults(List results) {
        LinkedList filteredResults = new LinkedList();
        for (Object result : results) {
            EntityReference entityReference = null;
            if (result instanceof EntityReference) {
                entityReference = (EntityReference)result;
            } else if (result instanceof Object[] && ((Object[])result)[0] instanceof EntityReference) {
                entityReference = (EntityReference)((Object[])result)[0];
            }
            if (entityReference == null || !this.authorization.hasAccess(Right.VIEW, entityReference)) continue;
            filteredResults.add(result);
        }
        return filteredResults;
    }
}

