/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.query.xwql.internal.QueryTranslator;

@Component
@Named(value="xwql")
@Singleton
public class XWQLQueryExecutor
implements QueryExecutor {
    @Inject
    @Named(value="hql")
    private QueryTranslator translator;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ModelContext context;

    public QueryManager getQueryManager() throws ComponentLookupException {
        return (QueryManager)this.componentManager.getInstance(QueryManager.class);
    }

    public <T> List<T> execute(Query query) throws QueryException {
        EntityReference currentEntityReference = this.context.getCurrentEntityReference();
        try {
            if (query.getWiki() != null) {
                if (currentEntityReference.getType() == EntityType.WIKI) {
                    this.context.setCurrentEntityReference((EntityReference)new WikiReference(query.getWiki()));
                } else {
                    this.context.setCurrentEntityReference(currentEntityReference.replaceParent(currentEntityReference.extractReference(EntityType.WIKI), (EntityReference)new WikiReference(query.getWiki())));
                }
            }
            Query nativeQuery = this.getQueryManager().createQuery(this.translator.translate(query.getStatement()), this.translator.getOutputLanguage());
            nativeQuery.setLimit(query.getLimit());
            nativeQuery.setOffset(query.getOffset());
            nativeQuery.setWiki(query.getWiki());
            if (query.getFilters() != null) {
                for (QueryFilter queryFilter : query.getFilters()) {
                    nativeQuery.addFilter(queryFilter);
                }
            }
            for (Map.Entry entry : query.getNamedParameters().entrySet()) {
                nativeQuery.bindValue((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : query.getPositionalParameters().entrySet()) {
                nativeQuery.bindValue(((Integer)entry.getKey()).intValue(), entry.getValue());
            }
            List i$ = nativeQuery.execute();
            return i$;
        }
        catch (Exception e) {
            if (e instanceof QueryException) {
                throw (QueryException)e;
            }
            throw new QueryException("Exception while translating [" + query.getStatement() + "] XWQL query to the [" + this.translator.getOutputLanguage() + "] language", query, (Throwable)e);
        }
        finally {
            this.context.setCurrentEntityReference(currentEntityReference);
        }
    }

    public QueryTranslator getTranslator() {
        return this.translator;
    }
}

