/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.ConfiguredProvider;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.ReputationAlgorithm;
import org.xwiki.ratings.ReputationAlgorithmGroovy;

@Component
@Singleton
public class ConfiguredReputationAlgorithmProvider
implements ConfiguredProvider<ReputationAlgorithm> {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ConfiguredProvider<RatingsManager> ratingsManagerProvider;
    @Inject
    private RatingsConfiguration ratingsConfiguration;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    @Override
    public ReputationAlgorithm get(DocumentReference documentRef) {
        String defaultAlgorithmHint = "default";
        String reputationAlgorithmHint = this.getXWiki().Param("xwiki.ratings.reputationAlgorithmHint", defaultAlgorithmHint);
        try {
            XWikiDocument configurationDocument = this.ratingsConfiguration.getConfigurationDocument(documentRef);
            if (configurationDocument != null && !configurationDocument.isNew() && configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE) != null) {
                String hint;
                BaseProperty prop = (BaseProperty)configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE).get("reputationAlgorithmHint");
                String string = hint = prop == null ? null : (String)prop.getValue();
                if (hint == "custom") {
                    prop = (BaseProperty)configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE).get("reputationCustomAlgorithm");
                    hint = prop == null ? null : (String)prop.getValue();
                }
                reputationAlgorithmHint = hint == null ? reputationAlgorithmHint : hint;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot read reputation algorithm config", (Throwable)e);
        }
        if (reputationAlgorithmHint.contains(".")) {
            try {
                ReputationAlgorithmGroovy reputationInstance = (ReputationAlgorithmGroovy)this.getXWiki().parseGroovyFromPage(reputationAlgorithmHint, this.getXWikiContext());
                if (reputationInstance != null) {
                    reputationInstance.setComponentManager(this.componentManager);
                    reputationInstance.setExecution(this.execution);
                    reputationInstance.setXWikiContext(this.getXWikiContext());
                    reputationInstance.setRatingsManager(this.ratingsManagerProvider.get(documentRef));
                    return reputationInstance;
                }
            }
            catch (Throwable e) {
                this.logger.error("Cannot instanciate Reputation algorithm from page " + reputationAlgorithmHint, e);
            }
        }
        try {
            return (ReputationAlgorithm)this.componentManager.getInstance(ReputationAlgorithm.class, reputationAlgorithmHint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error loading ratings manager component for hint " + reputationAlgorithmHint, (Throwable)e);
            try {
                return (ReputationAlgorithm)this.componentManager.getInstance(ReputationAlgorithm.class, defaultAlgorithmHint);
            }
            catch (ComponentLookupException e1) {
                return null;
            }
        }
    }
}

