/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.Date;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.internal.DefaultRatingsManager;

public class DefaultRating
implements Rating {
    private DocumentReference documentRef;
    private XWikiDocument document;
    private BaseObject object;
    private XWikiContext context;
    private DefaultRatingsManager ratingsManager;

    public DefaultRating(DocumentReference documentRef, DocumentReference author, int vote, XWikiContext context, DefaultRatingsManager ratingsManager) throws XWikiException {
        this(documentRef, author, new Date(), vote, context, ratingsManager);
    }

    public DefaultRating(DocumentReference documentRef, DocumentReference author, Date date, int vote, XWikiContext context, DefaultRatingsManager ratingsManager) throws XWikiException {
        this.context = context;
        this.documentRef = documentRef;
        this.ratingsManager = ratingsManager;
        this.createObject((String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)documentRef, new Object[0]), (String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)author, new Object[0]), date, vote);
    }

    public DefaultRating(DocumentReference documentRef, BaseObject obj, XWikiContext context, DefaultRatingsManager ratingsManager) {
        this.ratingsManager = ratingsManager;
        this.context = context;
        this.documentRef = documentRef;
        this.document = this.getDocument();
        this.object = obj;
    }

    @Override
    public String getRatingId() {
        return "" + this.object.getNumber();
    }

    @Override
    public String getGlobalRatingId() {
        return this.document.getFullName() + ":" + this.object.getNumber();
    }

    @Override
    public BaseObject getAsObject() {
        return this.object;
    }

    public XWikiDocument getDocument() {
        if (this.document == null) {
            try {
                this.document = this.context.getWiki().getDocument(this.documentRef, this.context);
            }
            catch (XWikiException xWikiException) {
                // empty catch block
            }
        }
        return this.document;
    }

    @Override
    public DocumentReference getAuthor() {
        String objectVal = this.object.getStringValue("author");
        return this.ratingsManager.userReferenceResolver.resolve((Object)objectVal, new Object[]{this.documentRef});
    }

    @Override
    public void setAuthor(DocumentReference author) {
        this.object.setStringValue("author", (String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)author, new Object[0]));
    }

    @Override
    public Date getDate() {
        return this.object.getDateValue("date");
    }

    @Override
    public void setDate(Date date) {
        this.object.setDateValue("date", date);
    }

    @Override
    public int getVote() {
        return this.object.getIntValue("vote");
    }

    @Override
    public void setVote(int vote) {
        this.object.setIntValue("vote", vote);
    }

    @Override
    public Object get(String propertyName) {
        try {
            return ((BaseProperty)this.getAsObject().get(propertyName)).getValue();
        }
        catch (XWikiException e) {
            return null;
        }
    }

    @Override
    public String display(String propertyName, String mode) {
        return this.document.display(propertyName, mode, this.object, this.context);
    }

    @Override
    public DocumentReference getDocumentReference() {
        return this.documentRef;
    }

    @Override
    public void save() throws RatingsException {
        try {
            this.getDocument().setContentDirty(false);
            this.context.getWiki().saveDocument(this.getDocument(), this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public boolean remove() {
        return this.remove(true);
    }

    protected boolean remove(boolean withSave) {
        try {
            XWikiDocument doc = this.getDocument();
            if (!doc.removeXObject(this.object)) {
                return false;
            }
            if (withSave) {
                this.context.getWiki().saveDocument(doc, this.context);
            }
            return true;
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return true;
        }
    }

    private void createObject(String documentName, String author, Date date, int vote) throws XWikiException {
        XWikiDocument doc = this.getDocument();
        BaseObject obj = doc.newXObject((EntityReference)RatingsManager.RATINGS_CLASSREFERENCE, this.context);
        obj.setStringValue("author", author);
        obj.setDateValue("date", date);
        obj.setIntValue("vote", vote);
        obj.setStringValue("parent", documentName);
        this.object = obj;
    }

    @Override
    public String toString() {
        boolean shouldAddSpace = false;
        StringBuffer sb = new StringBuffer();
        if (this.getAuthor() != null) {
            sb.append("\nAuthor=").append(this.getAuthor());
            shouldAddSpace = true;
        }
        if (this.getDate() != null) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nDate=").append(this.getDate());
            shouldAddSpace = true;
        }
        if (this.getVote() != -1) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nVote=").append(this.getVote()).append("\n");
            shouldAddSpace = true;
        }
        return sb.toString();
    }
}

