/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsManager;

@Component
@Singleton
public class DefaultRatingsConfiguration
implements RatingsConfiguration {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public XWikiDocument getDocument(EntityReference reference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            return context.getWiki().getDocument(reference, context);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to retrieve the document for the reference [{}].", (Object)reference, (Object)e);
            return null;
        }
    }

    @Override
    public XWikiDocument getConfigurationDocument(DocumentReference documentReference) {
        SpaceReference lastSpaceReference = documentReference.getLastSpaceReference();
        while (lastSpaceReference.getType() == EntityType.SPACE) {
            DocumentReference configurationDocumentReference = new DocumentReference("WebPreferences", lastSpaceReference);
            XWikiDocument spaceConfigurationDocument = this.getDocument((EntityReference)configurationDocumentReference);
            if (spaceConfigurationDocument != null && spaceConfigurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE) != null) {
                return spaceConfigurationDocument;
            }
            if (lastSpaceReference.getParent().getType() != EntityType.SPACE) break;
            lastSpaceReference = new SpaceReference(lastSpaceReference.getParent());
        }
        XWikiDocument globalConfigurationDocument = this.getDocument((EntityReference)RatingsManager.RATINGS_CONFIG_GLOBAL_REFERENCE);
        return globalConfigurationDocument;
    }

    @Override
    public String getConfigurationParameter(DocumentReference documentReference, String parameterName, String defaultValue) {
        XWikiDocument configurationDocument = this.getConfigurationDocument(documentReference);
        if (configurationDocument != null && !configurationDocument.isNew() && configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE) != null) {
            try {
                BaseProperty prop = (BaseProperty)configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE).get(parameterName);
                String propValue = prop == null ? defaultValue : prop.getValue().toString();
                return propValue.equals("") ? defaultValue : propValue;
            }
            catch (XWikiException e) {
                this.logger.error("Failed to retrieve the property for the configurationDocument [{}].", (Object)configurationDocument, (Object)e);
                return null;
            }
        }
        return defaultValue;
    }
}

