/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.UpdateRatingEvent;
import org.xwiki.ratings.UpdatingRatingEvent;
import org.xwiki.ratings.internal.AbstractRatingsManager;
import org.xwiki.ratings.internal.DefaultRating;

@Component
@Singleton
public class DefaultRatingsManager
extends AbstractRatingsManager {
    @Inject
    @Named(value="user/current")
    protected DocumentReferenceResolver<String> userReferenceResolver;
    @Inject
    @Named(value="compactwiki")
    protected EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rating setRating(DocumentReference documentRef, DocumentReference author, int vote) throws RatingsException {
        int oldVote;
        Rating rating = this.getRating(documentRef, author);
        if (rating == null) {
            oldVote = 0;
            try {
                rating = new DefaultRating(documentRef, author, vote, this.getXWikiContext(), this);
            }
            catch (XWikiException e) {
                throw new RatingsException(1120, e.getCode(), "Failed to create new rating object", (Exception)((Object)e));
            }
        } else {
            oldVote = rating.getVote();
            rating.setVote(vote);
            rating.setDate(new Date());
        }
        this.observationManager.notify((Event)new UpdatingRatingEvent(documentRef, rating, oldVote), null);
        boolean updateFailed = true;
        try {
            rating.save();
            this.updateAverageRatings(documentRef, rating, oldVote);
            updateFailed = false;
        }
        finally {
            if (updateFailed) {
                this.observationManager.notify((Event)new UpdatingRatingEvent(documentRef, rating, oldVote), null);
            } else {
                this.observationManager.notify((Event)new UpdateRatingEvent(documentRef, rating, oldVote), null);
            }
        }
        return rating;
    }

    @Override
    public List<Rating> getRatings(DocumentReference documentRef, int start, int count, boolean asc) throws RatingsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calling default manager code for ratings");
        }
        try {
            int skipped = 0;
            int nb = 0;
            XWikiDocument doc = this.getXWiki().getDocument(documentRef, this.getXWikiContext());
            Vector bobjects = doc.getObjects(this.getRatingsClassName());
            if (bobjects != null) {
                ArrayList<Rating> ratings = new ArrayList<Rating>();
                for (BaseObject bobj : bobjects) {
                    if (bobj == null) continue;
                    if (skipped < start) {
                        ++skipped;
                    } else {
                        ratings.add(this.getDefaultRating(documentRef, bobj));
                        ++nb;
                    }
                    if (count == 0 || nb != count) continue;
                    break;
                }
                return ratings;
            }
        }
        catch (XWikiException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Rating getRating(String ratingId) throws RatingsException {
        try {
            int i1 = ratingId.indexOf(":");
            if (i1 == -1) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, cannot parse rating id");
            }
            String docName = ratingId.substring(0, i1);
            String sObjectNb = ratingId.substring(i1 + 1);
            int objectNb = Integer.parseInt(sObjectNb);
            XWikiDocument doc = this.getXWiki().getDocument(docName, this.getXWikiContext());
            DocumentReference docRef = doc.getDocumentReference();
            if (doc.isNew()) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, document does not exist");
            }
            BaseObject object = doc.getObject(this.getRatingsClassName(), objectNb);
            if (object == null) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, could not find rating");
            }
            return new DefaultRating(docRef, object, this.getXWikiContext(), this);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public Rating getRating(DocumentReference documentRef, int id) throws RatingsException {
        try {
            int skipped = 0;
            XWikiDocument doc = this.getXWiki().getDocument(documentRef, this.getXWikiContext());
            Vector bobjects = doc.getObjects(this.getRatingsClassName());
            if (bobjects != null) {
                for (BaseObject bobj : bobjects) {
                    if (bobj == null) continue;
                    if (skipped < id) {
                        ++skipped;
                        continue;
                    }
                    return this.getDefaultRating(documentRef, bobj);
                }
            }
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return null;
    }

    @Override
    public Rating getRating(DocumentReference documentRef, DocumentReference author) throws RatingsException {
        try {
            if (author == null) {
                return null;
            }
            List<Rating> ratings = this.getRatings(documentRef, 0, 0, false);
            if (ratings == null) {
                return null;
            }
            for (Rating rating : ratings) {
                if (rating == null || !author.equals((Object)rating.getAuthor())) continue;
                return rating;
            }
        }
        catch (XWikiException e) {
            return null;
        }
        return null;
    }

    private DefaultRating getDefaultRating(DocumentReference documentRef, BaseObject bobj) {
        return new DefaultRating(documentRef, bobj, this.getXWikiContext(), this);
    }
}

