/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.ConfiguredProvider;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.ReputationAlgorithm;
import org.xwiki.ratings.ReputationException;

@Component
@Singleton
public class DefaultReputationAlgorithm
implements ReputationAlgorithm {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private ConfiguredProvider<RatingsManager> ratingsManagerProvider;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    @Override
    public RatingsManager getRatingsManager(DocumentReference documentRef) {
        return this.ratingsManagerProvider.get(documentRef);
    }

    @Override
    public void updateReputation(DocumentReference documentRef, Rating rating, int oldVote) {
        block17: {
            if (oldVote != rating.getVote()) {
                block16: {
                    block15: {
                        try {
                            AverageRating voterRating = this.calcNewVoterReputation(rating.getAuthor(), documentRef, rating, oldVote);
                            try {
                                this.getRatingsManager(documentRef).updateUserReputation(rating.getAuthor(), voterRating);
                            }
                            catch (RatingsException re) {
                                if (this.logger.isErrorEnabled()) {
                                    this.logger.error("Error while storing reputation for user " + rating.getAuthor(), (Throwable)((Object)re));
                                }
                            }
                        }
                        catch (ReputationException e) {
                            if (e.getCode() == 1121001 || !this.logger.isErrorEnabled()) break block15;
                            this.logger.error("Error while calculating voter reputation " + rating.getAuthor() + " for document " + documentRef, (Throwable)((Object)e));
                        }
                    }
                    try {
                        XWikiDocument doc = this.getXWiki().getDocument(documentRef, this.getXWikiContext());
                        AverageRating authorRating = this.calcNewContributorReputation(doc.getCreatorReference(), documentRef, rating, oldVote);
                        try {
                            this.getRatingsManager(documentRef).updateUserReputation(doc.getCreatorReference(), authorRating);
                        }
                        catch (RatingsException re) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("Error while storing reputation for user " + doc.getCreatorReference().getName(), (Throwable)((Object)re));
                            }
                        }
                    }
                    catch (ReputationException e) {
                        if (e.getCode() != 1121001 && this.logger.isErrorEnabled()) {
                            this.logger.error("Error while calculating author reputation for document " + documentRef, (Throwable)((Object)e));
                        }
                    }
                    catch (XWikiException e) {
                        if (!this.logger.isErrorEnabled()) break block16;
                        this.logger.error("Error while calculating author reputation for document " + documentRef, (Throwable)e);
                    }
                }
                try {
                    Map<String, AverageRating> e = this.calcNewAuthorsReputation(documentRef, rating, oldVote);
                }
                catch (ReputationException e) {
                    if (e.getCode() == 1121001 || !this.logger.isErrorEnabled()) break block17;
                    this.logger.error("Error while calculating authors reputation for document " + documentRef, (Throwable)((Object)e));
                }
            }
        }
    }

    @Override
    public AverageRating calcNewVoterReputation(DocumentReference voter, DocumentReference documentRef, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public AverageRating calcNewContributorReputation(DocumentReference contributor, DocumentReference documentRef, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public Map<String, AverageRating> calcNewAuthorsReputation(DocumentReference documentRef, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public Map<String, AverageRating> recalcAllReputation() throws ReputationException {
        this.notimplemented();
        return null;
    }

    protected void notimplemented() throws ReputationException {
        throw new ReputationException(1121, 1121001, "Not implemented");
    }
}

