/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.ConfiguredProvider;
import org.xwiki.ratings.ReputationAlgorithm;
import org.xwiki.ratings.UpdateRatingEvent;

@Component
@Named(value="updatereputation")
@Singleton
public class UpdateReputationListener
implements EventListener {
    @Inject
    private ConfiguredProvider<ReputationAlgorithm> reputationAlgorithm;

    public List<Event> getEvents() {
        return Arrays.asList(new UpdateRatingEvent());
    }

    public String getName() {
        return "updatereputation";
    }

    public void onEvent(Event event, Object arg1, Object arg2) {
        UpdateRatingEvent ratingEvent = (UpdateRatingEvent)event;
        DocumentReference documentRef = ratingEvent.getDocumentReference();
        this.reputationAlgorithm.get(documentRef).updateReputation(documentRef, ratingEvent.getNewRating(), ratingEvent.getOldRating());
    }
}

