/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.AsyncMacroParameters;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Named(value="async")
@Singleton
public class AsyncMacro
extends AbstractMacro<AsyncMacroParameters> {
    private static final String DESCRIPTION = "Asynchronous and cached execution of wiki content.";
    @Inject
    private BlockAsyncRendererExecutor executor;
    @Inject
    private MacroContentParser parser;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private AsyncContext asyncContext;
    @Inject
    private RenderingContext renderingContext;

    public AsyncMacro() {
        super("Async", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor("Content to execute", true, Block.LIST_BLOCK_TYPE), AsyncMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private String getCurrentSource(MacroTransformationContext context) {
        String currentSource = null;
        if (context != null) {
            MetaDataBlock metaDataBlock;
            currentSource = context.getTransformationContext() != null ? context.getTransformationContext().getId() : null;
            MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
            if (currentMacroBlock != null && (metaDataBlock = (MetaDataBlock)currentMacroBlock.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR_OR_SELF)) != null) {
                currentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
            }
        }
        return currentSource;
    }

    public List<Block> execute(AsyncMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom = this.parser.parse(content, context, false, context.isInline());
        if (xdom.getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        String source = this.getCurrentSource(context);
        ArrayList<Object> idElements = new ArrayList<Object>(4);
        idElements.add("async");
        idElements.add("macro");
        if (parameters.getId() != null) {
            idElements.addAll(parameters.getId());
        } else {
            long index;
            if (source != null) {
                idElements.add(source);
            }
            if ((index = context.getXDOM().indexOf((Block)context.getCurrentMacroBlock())) != -1L) {
                idElements.add(index);
            }
        }
        BlockAsyncRendererConfiguration configuration = new BlockAsyncRendererConfiguration(idElements, (Block)xdom);
        if (source != null) {
            DocumentReference sourceReference = this.resolver.resolve((Object)source, new Object[0]);
            configuration.setSecureReference(sourceReference, this.documentAccessBridge.getCurrentAuthorReference());
            configuration.useEntity((EntityReference)sourceReference);
        }
        configuration.setInline(context.isInline());
        configuration.setAsyncAllowed(parameters.isAsync());
        configuration.setCacheAllowed(parameters.isCached());
        configuration.setContextEntries(parameters.getContext());
        configuration.setDefaultSyntax(this.parser.getCurrentSyntax(context));
        configuration.setTargetSyntax(this.renderingContext.getTargetSyntax());
        configuration.setTransformationId(context.getTransformationContext().getId());
        try {
            Block result = this.executor.execute(configuration);
            if (!parameters.isAsync() || !this.asyncContext.isEnabled()) {
                result = new MetaDataBlock(Collections.singletonList(result), this.getNonGeneratedContentMetaData());
            }
            return Collections.singletonList(result);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed start the execution of the macro", (Throwable)e);
        }
    }
}

