/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.context.ContextMacroParameters;
import org.xwiki.rendering.macro.context.TransformationContextMode;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Named(value="context")
@Singleton
public class ContextMacro
extends AbstractMacro<ContextMacroParameters> {
    private static final String DESCRIPTION = "Executes content in the context of the passed document";
    private static final String CONTENT_DESCRIPTION = "The content to execute";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="macro")
    private DocumentReferenceResolver<String> macroDocumentReferenceResolver;
    @Inject
    private TransformationManager transformationManager;

    public ContextMacro() {
        super("Context", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), ContextMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Block> execute(ContextMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result;
        if (parameters.getDocument() == null) {
            throw new MacroExecutionException("You must specify a 'document' parameter pointing to the document to set in the context as the current document.");
        }
        DocumentReference referencedDocReference = this.macroDocumentReferenceResolver.resolve((Object)parameters.getDocument(), new Object[]{context.getCurrentMacroBlock()});
        boolean currentContextHasProgrammingRights = this.documentAccessBridge.hasProgrammingRights();
        try {
            HashMap backupObjects = new HashMap();
            try {
                this.documentAccessBridge.pushDocumentInContext(backupObjects, referencedDocReference);
                if (this.documentAccessBridge.hasProgrammingRights() && !currentContextHasProgrammingRights) {
                    throw new MacroExecutionException("Current document must have programming rights since the context document provided [" + parameters.getDocument() + "] has programming rights.");
                }
                MetaData metadata = new MetaData();
                metadata.addMetaData("source", (Object)parameters.getDocument());
                metadata.addMetaData("base", (Object)parameters.getDocument());
                XDOM xdom = this.contentParser.parse(content, context, false, metadata, false);
                if (parameters.getTransformationContext() == TransformationContextMode.DOCUMENT || parameters.getTransformationContext() == TransformationContextMode.TRANSFORMATIONS) {
                    DocumentModelBridge referencedDoc = this.documentAccessBridge.getTranslatedDocumentInstance(referencedDocReference);
                    XDOM referencedXDOM = referencedDoc.getXDOM();
                    if (parameters.getTransformationContext() == TransformationContextMode.TRANSFORMATIONS) {
                        TransformationContext referencedTxContext = new TransformationContext(referencedXDOM, referencedDoc.getSyntax());
                        this.transformationManager.performTransformations((Block)referencedXDOM, referencedTxContext);
                    }
                    TransformationContext txContext = new TransformationContext(referencedXDOM, referencedDoc.getSyntax());
                    this.transformationManager.performTransformations((Block)xdom, txContext);
                }
                result = Arrays.asList(new MetaDataBlock(xdom.getChildren(), xdom.getMetaData()));
            }
            finally {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
            }
        }
        catch (Exception e) {
            if (e instanceof MacroExecutionException) {
                throw (MacroExecutionException)e;
            }
            throw new MacroExecutionException(String.format("Failed to render page in the context of [%s]", referencedDocReference), (Throwable)e);
        }
        return result;
    }
}

